/**
 * 
 */
package org.richfaces.event.extdt;

import javax.faces.component.UIComponent;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;

/**
 * @author pawelgo
 *
 */
public class ColumnResizeEvent extends FacesEvent {
	
	private static final long serialVersionUID = -8424890931071484456L;
	
	private String columnWidths;

	public ColumnResizeEvent(UIComponent component, String columnWidths) {
		super(component);
		this.columnWidths = columnWidths;
	}

	/* (non-Javadoc)
	 * @see javax.faces.event.FacesEvent#isAppropriateListener(javax.faces.event.FacesListener)
	 */
	public boolean isAppropriateListener(FacesListener listener) {
		return (listener instanceof ColumnResizeListener);
	}

	/* (non-Javadoc)
	 * @see javax.faces.event.FacesEvent#processListener(javax.faces.event.FacesListener)
	 */
	public void processListener(FacesListener listener) {
		((ColumnResizeListener)listener).processColumnResize(this);
	}
	
	public String getColumnWidths() {
		return columnWidths;
	}

	public void setColumnWidths(String columnWidths) {
		this.columnWidths = columnWidths;
	}

}
