/**
 * 
 */
package org.richfaces.event.extdt;

import javax.faces.component.UIComponent;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;

/**
 * @author pawelgo
 *
 */
public class ChangeColumnVisibilityEvent extends FacesEvent {
	
	private static final long serialVersionUID = 178097339066092532L;
	
	private String columnId;
	
	public ChangeColumnVisibilityEvent(UIComponent component, String columnId) {
		super(component);
		this.columnId = columnId;
	}

	/* (non-Javadoc)
	 * @see javax.faces.event.FacesEvent#isAppropriateListener(javax.faces.event.FacesListener)
	 */
	public boolean isAppropriateListener(FacesListener listener) {
		return (listener instanceof ChangeColumnVisibilityListener);
	}

	/* (non-Javadoc)
	 * @see javax.faces.event.FacesEvent#processListener(javax.faces.event.FacesListener)
	 */
	public void processListener(FacesListener listener) {
		((ChangeColumnVisibilityListener)listener).processChangeVisibility(this);
	}
	
	public String getColumnId() {
		return columnId;
	}

	public void setColumnId(String columnId) {
		this.columnId = columnId;
	}

}
