/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.build.shade.resource;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jdom.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NamespacesTracker {
    private static final String GENERATED_NS_PREFIX_FORMAT = "x{0}";
    private Set<String> usedPrefixes = new HashSet<String>();
    private Map<String, Namespace> namespaces = new HashMap<String, Namespace>();
    private int prefixGeneratorCounter = 0;

    NamespacesTracker() {
    }

    private String maskEmptyString(String s) {
        if (s == null || s.trim().length() == 0) {
            return "";
        }
        return s;
    }

    private Namespace createNamespace(String uri, String prefix) {
        String maskedPrefix = this.maskEmptyString(prefix);
        while (this.usedPrefixes.contains(maskedPrefix)) {
            maskedPrefix = MessageFormat.format(GENERATED_NS_PREFIX_FORMAT, this.prefixGeneratorCounter++);
        }
        return Namespace.getNamespace((String)maskedPrefix, (String)uri);
    }

    public Namespace getNamespace(String nsUri, String nsPrefix) {
        String maskedUri = this.maskEmptyString(nsUri);
        Namespace namespace = this.namespaces.get(maskedUri);
        if (namespace == null) {
            namespace = this.createNamespace(maskedUri, nsPrefix);
            this.usedPrefixes.add(namespace.getPrefix());
            this.namespaces.put(maskedUri, namespace);
        }
        return namespace;
    }

    public Namespace getNamespace(Namespace namespace) {
        return this.getNamespace(namespace.getURI(), namespace.getPrefix());
    }

    public Collection<Namespace> getNamespaces() {
        return Collections.unmodifiableCollection(this.namespaces.values());
    }
}

