/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.build.shade.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;
import org.richfaces.build.shade.resource.NamespacesTracker;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseFacesResourceTransformer
implements ResourceTransformer {
    protected static final String META_INF_PATH = "META-INF/";
    protected static final String JAVAEE_PREFIX = "javaee";
    protected static final String JAVAEE_URI = "http://java.sun.com/xml/ns/javaee";
    private static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XSI_PREFIX = "xsi";
    protected NamespacesTracker namespacesFactory = new NamespacesTracker();

    protected static XPath createXPath(String path) throws JDOMException {
        XPath xPath = XPath.newInstance((String)path);
        xPath.addNamespace(Namespace.getNamespace((String)JAVAEE_PREFIX, (String)JAVAEE_URI));
        xPath.addNamespace(Namespace.getNamespace((String)XSI_PREFIX, (String)XSI_URI));
        return xPath;
    }

    protected Namespace getJavaEENamespace() {
        return this.namespacesFactory.getNamespace(JAVAEE_URI, null);
    }

    protected void addSchemaLocation(Element element, String schemaLocation) {
        if (schemaLocation != null && schemaLocation.length() != 0) {
            Namespace xsiNamespace = this.namespacesFactory.getNamespace(XSI_URI, XSI_PREFIX);
            element.setAttribute("schemaLocation", "http://java.sun.com/xml/ns/javaee " + schemaLocation, xsiNamespace);
        }
    }

    private void updateNamespaceRecursively(Object object) {
        if (object instanceof Element) {
            Element element = (Element)object;
            element.setNamespace(this.namespacesFactory.getNamespace(element.getNamespace()));
            for (Object attributeObject : element.getAttributes()) {
                Attribute attribute = (Attribute)attributeObject;
                if (Namespace.NO_NAMESPACE.equals((Object)attribute.getNamespace())) continue;
                attribute.setNamespace(this.namespacesFactory.getNamespace(attribute.getNamespace()));
            }
            for (Object child : element.getChildren()) {
                this.updateNamespaceRecursively(child);
            }
        }
    }

    protected boolean isJavaEEOrDefaultNamespace(Element element) {
        String namespaceURI = element.getNamespaceURI();
        if (namespaceURI == null || namespaceURI.trim().length() == 0) {
            return true;
        }
        return JAVAEE_URI.equals(namespaceURI);
    }

    protected Element cloneAndImportElement(Element element) {
        Element clonedElement = (Element)element.clone();
        this.updateNamespaceRecursively(clonedElement);
        return clonedElement;
    }

    protected List<Element> cloneAndImportElements(List<Element> elements) {
        ArrayList<Element> result = new ArrayList<Element>(elements.size());
        for (Element element : elements) {
            result.add(this.cloneAndImportElement(element));
        }
        return result;
    }

    protected void appendToStream(String resourceName, Document document, JarOutputStream jos) throws IOException {
        jos.putNextEntry(new JarEntry(resourceName));
        Format prettyFormat = Format.getPrettyFormat();
        prettyFormat.setIndent("    ");
        Element rootElement = document.getRootElement();
        Collection<Namespace> namespaces = this.namespacesFactory.getNamespaces();
        for (Namespace namespace : namespaces) {
            if (namespace.getPrefix().length() == 0) continue;
            rootElement.addNamespaceDeclaration(namespace);
        }
        new XMLOutputter(prettyFormat).output(document, (OutputStream)jos);
    }

    protected abstract void processDocument(String var1, Document var2, List var3) throws JDOMException;

    protected void resetTransformer() {
        this.namespacesFactory = new NamespacesTracker();
    }

    protected String getMetaInfResourceName(String resource) {
        if (!resource.startsWith(META_INF_PATH)) {
            return null;
        }
        String subPath = resource.substring(META_INF_PATH.length());
        if (subPath.contains("/")) {
            return null;
        }
        return subPath;
    }

    protected <T> List<T> checkedList(List<?> list, Class<T> clazz) {
        for (Object o : list) {
            if (clazz.isInstance(o)) continue;
            throw new ClassCastException(o.toString());
        }
        return list;
    }

    public void processResource(String resource, InputStream is, List relocators) throws IOException {
        try {
            SAXBuilder builder = new SAXBuilder(false);
            builder.setExpandEntities(false);
            builder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            Document document = builder.build(is);
            this.processDocument(resource, document, relocators);
        }
        catch (JDOMException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
    }
}

