/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xpath;

import org.planx.xpath.Context;
import org.planx.xpath.Environment;
import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.expr.Expression;
import org.planx.xpath.expr.XPathParser;
import org.planx.xpath.object.XObject;

public class XPath {
    private final Expression expr;
    private final Navigator nav;

    public XPath(String expr, Navigator nav) throws XPathException {
        try {
            XPathParser parser = new XPathParser(expr);
            this.expr = (Expression)parser.parse().value;
            this.nav = nav;
        }
        catch (Exception e) {
            throw new XPathException("Syntax error: " + e.toString());
        }
    }

    public XObject evaluate(Context ctxt, Environment env) throws XPathException {
        return this.expr.evaluate(ctxt, env, this.nav);
    }

    public XObject evaluate(Object ctxtNode, Environment env) throws XPathException {
        Context ctxt = new Context(ctxtNode, 1, 1);
        return this.evaluate(ctxt, env);
    }

    public XObject evaluate(Object ctxtNode) throws XPathException {
        Environment env = new Environment();
        return this.evaluate(ctxtNode, env);
    }

    public String toString() {
        return this.expr.toString();
    }
}

