/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.planx.util.Converter;
import org.planx.xmlstore.io.Streamer;

public class FileSystemIdentifier {
    private static final int LENGTH = 5;
    private int hash;
    private byte[] b;

    public FileSystemIdentifier() {
        this.b = new byte[5];
        for (int i = 0; i < 5; ++i) {
            this.b[i] = (byte)(Math.random() * 256.0);
        }
    }

    private FileSystemIdentifier(byte[] b) {
        this.b = b;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileSystemIdentifier)) {
            return false;
        }
        return Arrays.equals(this.b, ((FileSystemIdentifier)o).b);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Arrays.hashCode(this.b);
        }
        return this.hash;
    }

    byte[] internal() {
        return this.b;
    }

    public String toString() {
        return Converter.toHex(this.b);
    }

    public static Streamer<FileSystemIdentifier> getStreamer() {
        return new Streamer<FileSystemIdentifier>(){

            @Override
            public void toStream(DataOutput out, FileSystemIdentifier fsi) throws IOException {
                out.write(fsi.b);
            }

            @Override
            public FileSystemIdentifier fromStream(DataInput in) throws IOException {
                byte[] b = new byte[5];
                in.readFully(b);
                return new FileSystemIdentifier(b);
            }
        };
    }
}

