package org.planx.xmlstore.regions;

public class RegionConfiguration {
    public static final int POLICY_FIRST              = 0x01;
    public static final int POLICY_LEAST_INTER_REGION = 0x02;

    /** Minimum region size in bytes. */
    public int     REGION_SIZE           = 1*1024*1024;
    /** Maximum number of regions to keep in the memory cache.
        Must minimum be 2, but should rather be more. */
    public int     CACHE_SIZE            = 10;
    /** If <code>true</code> a hash sharer will be used instead of MSD. */
    public boolean USE_HASH_SHARER       = false;
    /** If <code>true</code> new regions will be compacted before saving. */
    public boolean DO_SHARE_NEW          = true;
    /** If <code>true</code> the sharer will run as a background thread. */
    public boolean ENABLE_SHARER         = true;
    /** If the sharer is enabled, the number of milli seconds between invocations. */
    public long    SHARER_PERIOD         = 10*1000;

    /** An implementation of a canonical node chooseing policy.
        Set to <code>null</code> to choose using <code>POLICY</code> instead. */
    public CanonicPolicy POLICY_INSTANCE = null;
    /** If <code>POLICY_INSTANCE</code> is <code>null</code> the value of a
        default policy as defined in the static fields of this class. */
    public int POLICY = POLICY_LEAST_INTER_REGION;

    /**
     * Returns a <code>RegionConfiguration</code> with values of fields filled
     * in from environment properties with corresponding names.
     */
    public static RegionConfiguration environmentConfiguration() {
        RegionConfiguration conf = new RegionConfiguration();
        conf.REGION_SIZE = getInt("REGION_SIZE", conf.REGION_SIZE);
        conf.CACHE_SIZE = getInt("CACHE_SIZE", conf.CACHE_SIZE);
        conf.USE_HASH_SHARER = getBoolean("USE_HASH_SHARER", conf.USE_HASH_SHARER);
        conf.DO_SHARE_NEW = getBoolean("DO_SHARE_NEW", conf.DO_SHARE_NEW);
        conf.ENABLE_SHARER = getBoolean("ENABLE_SHARER", conf.ENABLE_SHARER);
        conf.SHARER_PERIOD = getLong("SHARER_PERIOD", conf.SHARER_PERIOD);
        conf.POLICY = getInt("POLICY", conf.POLICY);
        return conf;
    }

    private static int getInt(String name, int d) {
        String p;
        return (p=getProperty(name))==null ? d : Integer.parseInt(p);
    }

    private static long getLong(String name, long d) {
        String p;
        return (p=getProperty(name))==null ? d : Long.parseLong(p);
    }

    private static boolean getBoolean(String name, boolean d) {
        String p;
        return (p=getProperty(name))==null ? d : Boolean.parseBoolean(p);
    }

    private static String getProperty(String name) {
        String p = System.getenv(name);
        return (p==null)?null:(p.length()==0)?null:p;
    }

    public String toString() {
        return "RegionConfiguration\n"+
               "  REGION_SIZE     = "+REGION_SIZE+"\n"+
               "  CACHE_SIZE      = "+CACHE_SIZE+"\n"+
               "  USE_HASH_SHARER = "+USE_HASH_SHARER+"\n"+
               "  DO_SHARE_NEW    = "+DO_SHARE_NEW+"\n"+
               "  ENABLE_SHARER   = "+ENABLE_SHARER+"\n"+
               "  SHARER_PERIOD   = "+SHARER_PERIOD+"\n"+
               "  POLICY_INSTANCE = "+((POLICY_INSTANCE==null)?"null"
                        :POLICY_INSTANCE.getClass().getName())+"\n";
    }
}

