/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.FileTypeAnalyzer;
import org.owasp.dependencycheck.exception.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileTypeAnalyzer
extends AbstractAnalyzer
implements FileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFileTypeAnalyzer.class);
    private boolean filesMatched = false;

    protected boolean isFilesMatched() {
        return this.filesMatched;
    }

    protected void setFilesMatched(boolean filesMatched) {
        this.filesMatched = filesMatched;
    }

    @Override
    protected final void initializeAnalyzer() throws InitializationException {
        if (this.filesMatched) {
            this.initializeFileTypeAnalyzer();
        } else {
            this.setEnabled(false);
        }
    }

    protected abstract FileFilter getFileFilter();

    protected abstract void initializeFileTypeAnalyzer() throws InitializationException;

    @Override
    public boolean accept(File pathname) {
        FileFilter filter = this.getFileFilter();
        boolean accepted = false;
        if (null == filter) {
            LOGGER.error("The '{}' analyzer is misconfigured and does not have a file filter; it will be disabled", (Object)this.getName());
        } else if (this.isEnabled() && (accepted = filter.accept(pathname))) {
            this.filesMatched = true;
        }
        return accepted;
    }

    protected static Set<String> newHashSet(String ... strings) {
        HashSet<String> set = new HashSet<String>(strings.length);
        Collections.addAll(set, strings);
        return set;
    }
}

