/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.pom;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.owasp.dependencycheck.xml.pom.Model;
import org.owasp.dependencycheck.xml.pom.PomHandler;
import org.owasp.dependencycheck.xml.pom.PomParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class PomParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(PomParser.class);

    public Model parse(File file) throws PomParseException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            Model model = this.parse(fis);
            return model;
        }
        catch (IOException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new PomParseException(ex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    LOGGER.debug("Unable to close stream", (Throwable)ex);
                }
            }
        }
    }

    public Model parse(InputStream inputStream) throws PomParseException {
        try {
            PomHandler handler = new PomHandler();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setContentHandler(handler);
            InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
            InputSource in = new InputSource(reader);
            xmlReader.parse(in);
            return handler.getModel();
        }
        catch (ParserConfigurationException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new PomParseException(ex);
        }
        catch (SAXException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new PomParseException(ex);
        }
        catch (FileNotFoundException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new PomParseException(ex);
        }
        catch (IOException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new PomParseException(ex);
        }
    }
}

