/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Analyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Evidence;

public class HintAnalyzer
extends AbstractAnalyzer
implements Analyzer {
    private static final String ANALYZER_NAME = "Hint Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.PRE_IDENTIFIER_ANALYSIS;

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    public void analyze(Dependency dependency, Engine engine) throws AnalysisException {
        Evidence springTest1 = new Evidence("Manifest", "Implementation-Title", "Spring Framework", Confidence.HIGH);
        Evidence springTest2 = new Evidence("Manifest", "Implementation-Title", "org.springframework.core", Confidence.HIGH);
        Evidence springTest3 = new Evidence("Manifest", "Implementation-Title", "spring-core", Confidence.HIGH);
        Evidence springTest4 = new Evidence("jar", "package name", "springframework", Confidence.LOW);
        Evidence springSecurityTest1 = new Evidence("Manifest", "Bundle-Name", "Spring Security Core", Confidence.MEDIUM);
        Evidence springSecurityTest2 = new Evidence("pom", "artifactid", "spring-security-core", Confidence.HIGH);
        Evidence symfony = new Evidence("composer.lock", "vendor", "symfony", Confidence.HIGHEST);
        Evidence zendframeworkVendor = new Evidence("composer.lock", "vendor", "zendframework", Confidence.HIGHEST);
        Evidence zendframeworkProduct = new Evidence("composer.lock", "product", "zendframework", Confidence.HIGHEST);
        Set<Evidence> product = dependency.getProductEvidence().getEvidence();
        Set<Evidence> vendor = dependency.getVendorEvidence().getEvidence();
        if (product.contains(springTest1) || product.contains(springTest2) || product.contains(springTest3) || dependency.getFileName().contains("spring") && product.contains(springTest4)) {
            dependency.getProductEvidence().addEvidence("hint analyzer", "product", "springsource spring framework", Confidence.HIGH);
            dependency.getVendorEvidence().addEvidence("hint analyzer", "vendor", "SpringSource", Confidence.HIGH);
            dependency.getVendorEvidence().addEvidence("hint analyzer", "vendor", "vmware", Confidence.HIGH);
            dependency.getVendorEvidence().addEvidence("hint analyzer", "vendor", "pivotal", Confidence.HIGH);
        }
        if (vendor.contains(springTest4)) {
            dependency.getProductEvidence().addEvidence("hint analyzer", "product", "springsource_spring_framework", Confidence.HIGH);
            dependency.getVendorEvidence().addEvidence("hint analyzer", "vendor", "vmware", Confidence.HIGH);
            dependency.getVendorEvidence().addEvidence("hint analyzer", "vendor", "pivotal", Confidence.HIGH);
        }
        if (product.contains(springSecurityTest1) || product.contains(springSecurityTest2)) {
            dependency.getProductEvidence().addEvidence("hint analyzer", "product", "springsource_spring_security", Confidence.HIGH);
            dependency.getVendorEvidence().addEvidence("hint analyzer", "vendor", "SpringSource", Confidence.HIGH);
            dependency.getVendorEvidence().addEvidence("hint analyzer", "vendor", "vmware", Confidence.HIGH);
        }
        if (vendor.contains(symfony)) {
            dependency.getVendorEvidence().addEvidence("hint analyzer", "vendor", "sensiolabs", Confidence.HIGHEST);
        }
        if (vendor.contains(zendframeworkVendor)) {
            dependency.getVendorEvidence().addEvidence("hint analyzer", "vendor", "zend", Confidence.HIGHEST);
        }
        if (product.contains(zendframeworkProduct)) {
            dependency.getProductEvidence().addEvidence("hint analyzer", "vendor", "zend_framework", Confidence.HIGHEST);
        }
        Iterator<Evidence> itr = dependency.getVendorEvidence().iterator();
        ArrayList<Evidence> newEntries = new ArrayList<Evidence>();
        while (itr.hasNext()) {
            Evidence newEvidence;
            Evidence e = itr.next();
            if ("sun".equalsIgnoreCase(e.getValue(false))) {
                newEvidence = new Evidence(e.getSource() + " (hint)", e.getName(), "oracle", e.getConfidence());
                newEntries.add(newEvidence);
                continue;
            }
            if (!"oracle".equalsIgnoreCase(e.getValue(false))) continue;
            newEvidence = new Evidence(e.getSource() + " (hint)", e.getName(), "sun", e.getConfidence());
            newEntries.add(newEvidence);
        }
        for (Evidence e : newEntries) {
            dependency.getVendorEvidence().addEvidence(e);
        }
    }
}

