/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.junit.internal;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.internal.runners.TestClass;
import org.junit.internal.runners.TestMethod;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.exam.Info;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.OptionUtils;
import org.ops4j.pax.exam.junit.extender.CallableTestMethod;
import org.ops4j.pax.exam.options.FrameworkOption;
import org.ops4j.pax.exam.runtime.PaxExamRuntime;
import org.ops4j.pax.exam.spi.container.TestContainer;
import org.ops4j.pax.exam.spi.container.TestContainerFactory;

public class JUnit4TestMethod
extends TestMethod {
    private static final int NOT_STARTED = 0;
    private static final int CONTAINER_STARTED = 1;
    private static final int PROBE_INSTALLED = 2;
    private static final int PROBE_STARTED = 3;
    private static final int SUCCESFUL = 4;
    private static final Log LOG = LogFactory.getLog(JUnit4TestMethod.class);
    private final Method m_testMethod;
    private final Option[] m_options;
    private final String m_name;
    private final String m_testBundleUrl;

    public JUnit4TestMethod(Method testMethod, TestClass testClass, FrameworkOption frameworkOption, Option ... userOptions) {
        super(testMethod, testClass);
        NullArgumentException.validateNotNull((Object)testMethod, (String)"Test method");
        NullArgumentException.validateNotNull((Object)testClass, (String)"Test class");
        this.m_testMethod = testMethod;
        this.m_options = OptionUtils.combine((Option[])userOptions, (Option[])new Option[]{frameworkOption});
        this.m_name = JUnit4TestMethod.calculateName(testMethod.getName(), frameworkOption);
        this.m_testBundleUrl = JUnit4TestMethod.getTestBundleUrl(testClass.getName(), this.m_testMethod.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Object test) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Info.showLogo();
        String fullTestName = this.m_name + "(" + this.m_testMethod.getDeclaringClass().getName() + ")";
        LOG.info((Object)("Starting test " + fullTestName));
        int executionState = 0;
        TestContainerFactory containerFactory = PaxExamRuntime.getTestContainerFactory();
        TestContainer container = null;
        try {
            LOG.trace((Object)"Start test container");
            container = containerFactory.newInstance(this.m_options);
            container.start();
            executionState = 1;
            LOG.trace((Object)"Install and start test bundle");
            long bundleId = container.installBundle(this.m_testBundleUrl);
            executionState = 2;
            container.setBundleStartLevel(bundleId, 2);
            container.startBundle(bundleId);
            executionState = 3;
            LOG.trace((Object)("Execute test [" + this.m_name + "]"));
            CallableTestMethod callable = (CallableTestMethod)container.getService(CallableTestMethod.class);
            try {
                LOG.info((Object)("Starting test " + fullTestName));
                callable.call();
                LOG.info((Object)("Test " + fullTestName + " ended succesfully"));
                executionState = 4;
            }
            catch (InstantiationException e) {
                throw new InvocationTargetException(e);
            }
            catch (ClassNotFoundException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            if (container != null) {
                try {
                    container.stop();
                }
                catch (RuntimeException ignore) {
                    if (executionState >= 4) {
                        throw ignore;
                    }
                    LOG.error((Object)("Cannot stop the test container: " + ignore.getMessage()));
                }
            }
        }
    }

    public Method getTestMethod() {
        return this.m_testMethod;
    }

    public String getName() {
        return this.m_name;
    }

    private static String calculateName(String testMethodName, FrameworkOption frameworkOption) {
        StringBuilder name = new StringBuilder();
        name.append(testMethodName);
        if (frameworkOption != null) {
            name.append(" [").append(frameworkOption.getName());
            String version = frameworkOption.getVersion();
            if (version != null) {
                name.append("/").append(version);
            }
            name.append("]");
        }
        return name.toString();
    }

    private static String getTestBundleUrl(String testClassName, String testMethodName) {
        StringBuilder url = new StringBuilder();
        url.append("dir:").append(new File(".").getAbsolutePath()).append("$").append("tail=").append(testClassName.replace(".", "/")).append(".class").append("&").append("PaxExam-TestClassName").append("=").append(testClassName).append("&").append("PaxExam-TestMethodName").append("=").append(testMethodName).append("&").append("Bundle-SymbolicName").append("=").append("pax-exam-probe").append("&").append("DynamicImport-Package").append("=*").append("&").append("Export-Package").append("=!*");
        return url.toString();
    }
}

