/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.renderer.AbstractRenderer;
import org.openscience.cdk.renderer.AtomContainerRenderer;
import org.openscience.cdk.renderer.AverageBondLengthCalculator;
import org.openscience.cdk.renderer.BoundsCalculator;
import org.openscience.cdk.renderer.IRenderer;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.font.IFontManager;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.visitor.IDrawVisitor;

public class MoleculeSetRenderer
extends AbstractRenderer<IAtomContainerSet>
implements IRenderer<IAtomContainerSet> {
    private IRenderer<IAtomContainer> atomContainerRenderer;

    public MoleculeSetRenderer(List<IGenerator<IAtomContainer>> generators, IFontManager fontManager) {
        this(new RendererModel(), generators, fontManager);
    }

    public MoleculeSetRenderer(RendererModel rendererModel, List<IGenerator<IAtomContainer>> generators, IFontManager fontManager) {
        super(rendererModel);
        for (IGenerator<IAtomContainer> generator : generators) {
            rendererModel.registerParameters(generator);
        }
        this.fontManager = fontManager;
        this.atomContainerRenderer = new AtomContainerRenderer(rendererModel, generators, fontManager);
        this.generators = Collections.emptyList();
        this.setup();
    }

    public void setup(IAtomContainerSet moleculeSet, Rectangle screen) {
        this.setScale(moleculeSet);
        Rectangle2D bounds = BoundsCalculator.calculateBounds((IAtomContainerSet)moleculeSet);
        if (bounds != null) {
            this.modelCenter = new Point2d(bounds.getCenterX(), bounds.getCenterY());
        }
        this.drawCenter = new Point2d(screen.getCenterX(), screen.getCenterY());
        this.setup();
    }

    public Rectangle shift(Rectangle screenBounds, Rectangle diagramBounds) {
        int screenMaxX = screenBounds.x + screenBounds.width;
        int screenMaxY = screenBounds.y + screenBounds.height;
        int diagramMaxX = diagramBounds.x + diagramBounds.width;
        int diagramMaxY = diagramBounds.y + diagramBounds.height;
        int leftOverlap = screenBounds.x - diagramBounds.x;
        int rightOverlap = diagramMaxX - screenMaxX;
        int topOverlap = screenBounds.y - diagramBounds.y;
        int bottomOverlap = diagramMaxY - screenMaxY;
        int diffx = 0;
        int diffy = 0;
        int width = screenBounds.width;
        int height = screenBounds.height;
        if (leftOverlap > 0) {
            diffx = leftOverlap;
        }
        if (rightOverlap > 0) {
            width += rightOverlap;
        }
        if (topOverlap > 0) {
            diffy = topOverlap;
        }
        if (bottomOverlap > 0) {
            height += bottomOverlap;
        }
        if (diffx != 0 || diffy != 0) {
            this.shiftDrawCenter(diffx, diffy);
        }
        return new Rectangle(diffx, diffy, width, height);
    }

    public void setScale(IAtomContainerSet moleculeSet) {
        double bondLength = AverageBondLengthCalculator.calculateAverageBondLength((IAtomContainerSet)moleculeSet);
        double scale = this.calculateScaleForBondLength(bondLength);
        ((BasicSceneGenerator.Scale)this.rendererModel.getParameter(BasicSceneGenerator.Scale.class)).setValue((Object)scale);
    }

    public Rectangle paint(IAtomContainerSet moleculeSet, IDrawVisitor drawVisitor) {
        Rectangle2D totalBounds = BoundsCalculator.calculateBounds((IAtomContainerSet)moleculeSet);
        this.setupTransformNatural(totalBounds);
        IRenderingElement diagram = this.generateDiagram(moleculeSet);
        this.paint(drawVisitor, diagram);
        return this.convertToDiagramBounds(totalBounds);
    }

    public void paint(IAtomContainerSet molecules, IDrawVisitor drawVisitor, Rectangle2D bounds, boolean resetCenter) {
        Rectangle2D totalBounds = BoundsCalculator.calculateBounds((IAtomContainerSet)molecules);
        this.setupTransformToFit(bounds, totalBounds, AverageBondLengthCalculator.calculateAverageBondLength((IAtomContainerSet)molecules), resetCenter);
        IRenderingElement diagram = this.generateDiagram(molecules);
        this.paint(drawVisitor, diagram);
    }

    public IRenderingElement generateDiagram(IAtomContainerSet molecules) {
        ElementGroup diagram = new ElementGroup();
        for (IAtomContainer molecule : molecules.atomContainers()) {
            diagram.add(this.atomContainerRenderer.generateDiagram((IChemObject)molecule));
        }
        return diagram;
    }

    public Rectangle calculateDiagramBounds(IAtomContainerSet moleculeSet) {
        if (moleculeSet == null) {
            return this.calculateScreenBounds(new Rectangle2D.Double());
        }
        return this.calculateScreenBounds(BoundsCalculator.calculateBounds((IAtomContainerSet)moleculeSet));
    }

    public double calculateScaleForBondLength(double modelBondLength) {
        if (Double.isNaN(modelBondLength) || modelBondLength == 0.0) {
            return ((BasicSceneGenerator.Scale)this.rendererModel.getParameter(BasicSceneGenerator.Scale.class)).getDefault();
        }
        return (Double)((BasicSceneGenerator.BondLength)this.rendererModel.getParameter(BasicSceneGenerator.BondLength.class)).getValue() / modelBondLength;
    }

    public List<IGenerator<IAtomContainerSet>> getGenerators() {
        return new ArrayList<IGenerator<IAtomContainerSet>>(this.generators);
    }
}

