/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class ReorderAnnotations
extends Recipe {
    private static final Comparator<J.Annotation> comparator = Comparator.comparing(a -> {
        if (a.getType() instanceof JavaType.Class) {
            for (JavaType.FullyQualified fq : ((JavaType.Class)a.getType()).getAnnotations()) {
                if (!TypeUtils.isOfClassType((JavaType)fq, (String)"java.lang.annotation.Target")) continue;
                for (JavaType.Annotation.ElementValue elementValue : ((JavaType.Annotation)fq).getValues()) {
                    Object value = elementValue.getValue();
                    if (value instanceof List) {
                        for (Object item : (List)value) {
                            if (!(item instanceof JavaType.Variable) || !"TYPE_USE".equals(((JavaType.Variable)item).getName())) continue;
                            return 1;
                        }
                        continue;
                    }
                    if (!(value instanceof JavaType.Variable) || !"TYPE_USE".equals(((JavaType.Variable)value).getName())) continue;
                    return 1;
                }
            }
        }
        return 0;
    }).thenComparing(J.Annotation::getSimpleName);

    public String getDisplayName() {
        return "Reorder annotations alphabetically";
    }

    public String getDescription() {
        return "Consistently order annotations by comparing their simple name.";
    }

    public JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration d = super.visitClassDeclaration(classDecl, (Object)ctx);
                if (1 < d.getLeadingAnnotations().size()) {
                    ArrayList sortedAnnotations = new ArrayList(d.getLeadingAnnotations());
                    sortedAnnotations.sort(comparator);
                    if (!sortedAnnotations.equals(d.getLeadingAnnotations())) {
                        return d.withLeadingAnnotations(ListUtils.map(sortedAnnotations, (i, a) -> a.withPrefix(((J.Annotation)d.getLeadingAnnotations().get((int)i)).getPrefix())));
                    }
                }
                return d;
            }

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                J.VariableDeclarations d = super.visitVariableDeclarations(multiVariable, (Object)ctx);
                if (1 < d.getLeadingAnnotations().size()) {
                    ArrayList sortedAnnotations = new ArrayList(d.getLeadingAnnotations());
                    sortedAnnotations.sort(comparator);
                    if (!sortedAnnotations.equals(d.getLeadingAnnotations())) {
                        return d.withLeadingAnnotations(ListUtils.map(sortedAnnotations, (i, a) -> a.withPrefix(((J.Annotation)d.getLeadingAnnotations().get((int)i)).getPrefix())));
                    }
                }
                return d;
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration d = super.visitMethodDeclaration(method, (Object)ctx);
                if (1 < d.getLeadingAnnotations().size()) {
                    ArrayList sortedAnnotations = new ArrayList(d.getLeadingAnnotations());
                    sortedAnnotations.sort(comparator);
                    if (!sortedAnnotations.equals(d.getLeadingAnnotations())) {
                        return d.withLeadingAnnotations(ListUtils.map(sortedAnnotations, (i, a) -> a.withPrefix(((J.Annotation)d.getLeadingAnnotations().get((int)i)).getPrefix())));
                    }
                }
                return d;
            }
        };
    }

    @Generated
    public ReorderAnnotations() {
    }

    @Generated
    public String toString() {
        return "ReorderAnnotations()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReorderAnnotations)) {
            return false;
        }
        ReorderAnnotations other = (ReorderAnnotations)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReorderAnnotations;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

