/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import java.time.Duration;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;
import org.openrewrite.yaml.tree.YamlKey;

public final class SetupPythonToUv
extends Recipe {
    @Option(displayName="UV version", description="The version of the `astral-sh/setup-uv` action to use. Defaults to `v6`.", example="v6", required=false)
    private final @Nullable String uvVersion;
    @Option(displayName="Sync strategy", description="Strategy for the `uv sync` command replacement.", example="locked", valid={"basic", "locked", "full"}, required=false)
    private final @Nullable String syncStrategy;
    @Option(displayName="Transform pip commands", description="Whether to transform `pip install` commands to `uv` equivalents:\n- `pip install -r requirements.txt` \u2192 `uv sync`\n- `pip install .` \u2192 `uv sync`\n- `python -m pytest` \u2192 `uv run pytest`\n\nWhen disabled, only the action itself is replaced. Defaults to `true`.", example="true", required=false)
    private final @Nullable Boolean transformPipCommands;
    @Option(displayName="Enable cache", description="Whether to automatically convert `cache: 'pip'` to `enable-cache: 'true'` for UV's built-in caching. When disabled, cache settings are left unchanged. Defaults to `true`.", example="true", required=false)
    private final @Nullable Boolean enableCache;

    public String getDisplayName() {
        return "Replace `actions/setup-python` with `astral-sh/setup-uv`";
    }

    public String getDescription() {
        return "Replace `actions/setup-python` action with `astral-sh/setup-uv` action for faster Python environment setup and dependency management.\n\n**Benefits of UV:**\n - Significantly faster package installation and environment setup\n - Built-in dependency resolution and locking\n - Integrated caching for improved CI performance\n - Drop-in replacement for pip workflows\n\n**Transformations applied:**\n - `actions/setup-python@v5` \u2192 `astral-sh/setup-uv@v6`\n - `cache: 'pip'` \u2192 `enable-cache: 'true'`\n - `pip install -r requirements.txt` \u2192 `uv sync` (configurable strategy)\n - `python -m <module>` \u2192 `uv run <module>`\n - Removes unnecessary `pip install --upgrade pip` steps\n\n**Sync strategies:**\n - `basic`: Basic synchronization (`uv sync`)\n - `locked`: Use locked dependencies (`uv sync --locked`)\n - `full`: Install all extras and dev dependencies (`uv sync --all-extras --dev`)\n\nSee the [UV GitHub integration guide](https://docs.astral.sh/uv/guides/integration/github/) for more details.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles(".github/workflows/*.yml"), (TreeVisitor)new SetupPythonToUvVisitor(this.uvVersion != null ? this.uvVersion : "v6", SetupPythonToUv.mapSyncStrategy(this.syncStrategy != null ? this.syncStrategy : "basic"), this.transformPipCommands != null ? this.transformPipCommands : true, this.enableCache != null ? this.enableCache : true));
    }

    private static String mapSyncStrategy(String strategy) {
        switch (strategy) {
            case "basic": {
                return "sync";
            }
            case "locked": {
                return "sync --locked";
            }
            case "full": {
                return "sync --all-extras --dev";
            }
        }
        return "sync";
    }

    @Generated
    public SetupPythonToUv(@Nullable String uvVersion, @Nullable String syncStrategy, @Nullable Boolean transformPipCommands, @Nullable Boolean enableCache) {
        this.uvVersion = uvVersion;
        this.syncStrategy = syncStrategy;
        this.transformPipCommands = transformPipCommands;
        this.enableCache = enableCache;
    }

    @Generated
    public @Nullable String getUvVersion() {
        return this.uvVersion;
    }

    @Generated
    public @Nullable String getSyncStrategy() {
        return this.syncStrategy;
    }

    @Generated
    public @Nullable Boolean getTransformPipCommands() {
        return this.transformPipCommands;
    }

    @Generated
    public @Nullable Boolean getEnableCache() {
        return this.enableCache;
    }

    @Generated
    public String toString() {
        return "SetupPythonToUv(uvVersion=" + this.getUvVersion() + ", syncStrategy=" + this.getSyncStrategy() + ", transformPipCommands=" + this.getTransformPipCommands() + ", enableCache=" + this.getEnableCache() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetupPythonToUv)) {
            return false;
        }
        SetupPythonToUv other = (SetupPythonToUv)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$transformPipCommands = this.getTransformPipCommands();
        Boolean other$transformPipCommands = other.getTransformPipCommands();
        if (this$transformPipCommands == null ? other$transformPipCommands != null : !((Object)this$transformPipCommands).equals(other$transformPipCommands)) {
            return false;
        }
        Boolean this$enableCache = this.getEnableCache();
        Boolean other$enableCache = other.getEnableCache();
        if (this$enableCache == null ? other$enableCache != null : !((Object)this$enableCache).equals(other$enableCache)) {
            return false;
        }
        String this$uvVersion = this.getUvVersion();
        String other$uvVersion = other.getUvVersion();
        if (this$uvVersion == null ? other$uvVersion != null : !this$uvVersion.equals(other$uvVersion)) {
            return false;
        }
        String this$syncStrategy = this.getSyncStrategy();
        String other$syncStrategy = other.getSyncStrategy();
        return !(this$syncStrategy == null ? other$syncStrategy != null : !this$syncStrategy.equals(other$syncStrategy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SetupPythonToUv;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $transformPipCommands = this.getTransformPipCommands();
        result = result * 59 + ($transformPipCommands == null ? 43 : ((Object)$transformPipCommands).hashCode());
        Boolean $enableCache = this.getEnableCache();
        result = result * 59 + ($enableCache == null ? 43 : ((Object)$enableCache).hashCode());
        String $uvVersion = this.getUvVersion();
        result = result * 59 + ($uvVersion == null ? 43 : $uvVersion.hashCode());
        String $syncStrategy = this.getSyncStrategy();
        result = result * 59 + ($syncStrategy == null ? 43 : $syncStrategy.hashCode());
        return result;
    }

    private static class SetupPythonToUvVisitor
    extends YamlIsoVisitor<ExecutionContext> {
        private static final Pattern SETUP_PYTHON_PATTERN = Pattern.compile("^actions/setup-python(@.*)?$");
        private static final Pattern PIP_INSTALL_REQUIREMENTS = Pattern.compile("^pip install -r requirements\\.txt$");
        private static final Pattern PIP_INSTALL_DEV = Pattern.compile("^pip install \\.$");
        private static final Pattern PIP_INSTALL_EDITABLE = Pattern.compile("^pip install -e \\.$");
        private static final Pattern PIP_UPGRADE = Pattern.compile("^python -m pip install --upgrade pip$");
        private static final Pattern PYTHON_MODULE_PATTERN = Pattern.compile("^python -m (.+)$");
        private final String uvVersion;
        private final String syncStrategy;
        private final boolean transformPipCommands;
        private final boolean enableCache;

        public SetupPythonToUvVisitor(String uvVersion, String syncStrategy, boolean transformPipCommands, boolean enableCache) {
            this.uvVersion = uvVersion;
            this.syncStrategy = syncStrategy;
            this.transformPipCommands = transformPipCommands;
            this.enableCache = enableCache;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
            Yaml.Mapping stepMapping;
            boolean hasSetupPython;
            Cursor withCursor;
            Cursor stepCursor;
            Cursor stepMappingCursor;
            if ("uses".equals(entry.getKey().getValue()) && entry.getValue() instanceof Yaml.Scalar && SETUP_PYTHON_PATTERN.matcher(((Yaml.Scalar)entry.getValue()).getValue()).matches()) {
                return entry.withValue((Yaml.Block)((Yaml.Scalar)entry.getValue()).withValue("astral-sh/setup-uv@" + this.uvVersion));
            }
            if (this.enableCache && "cache".equals(entry.getKey().getValue()) && entry.getValue() instanceof Yaml.Scalar && "pip".equals(((Yaml.Scalar)entry.getValue()).getValue())) {
                return entry.withKey((YamlKey)((Yaml.Scalar)entry.getKey()).withValue("enable-cache")).withValue((Yaml.Block)((Yaml.Scalar)entry.getValue()).withValue("true"));
            }
            if ("cache-dependency-path".equals(entry.getKey().getValue()) && (stepMappingCursor = (stepCursor = (withCursor = this.getCursor().getParentOrThrow()).getParentOrThrow()).getParentOrThrow()).getValue() instanceof Yaml.Mapping && (hasSetupPython = (stepMapping = (Yaml.Mapping)stepMappingCursor.getValue()).getEntries().stream().anyMatch(e -> {
                if ("uses".equals(e.getKey().getValue()) && e.getValue() instanceof Yaml.Scalar) {
                    String value = ((Yaml.Scalar)e.getValue()).getValue();
                    return value.startsWith("actions/setup-python");
                }
                return false;
            }))) {
                return null;
            }
            if (this.transformPipCommands && "run".equals(entry.getKey().getValue()) && entry.getValue() instanceof Yaml.Scalar) {
                String runCommand = ((Yaml.Scalar)entry.getValue()).getValue();
                if (PIP_UPGRADE.matcher(runCommand).matches()) {
                    return null;
                }
                if (PIP_INSTALL_REQUIREMENTS.matcher(runCommand).matches()) {
                    return entry.withValue((Yaml.Block)((Yaml.Scalar)entry.getValue()).withValue("uv " + this.syncStrategy));
                }
                if (PIP_INSTALL_DEV.matcher(runCommand).matches() || PIP_INSTALL_EDITABLE.matcher(runCommand).matches()) {
                    return entry.withValue((Yaml.Block)((Yaml.Scalar)entry.getValue()).withValue("uv " + this.syncStrategy));
                }
                if (PYTHON_MODULE_PATTERN.matcher(runCommand).matches()) {
                    String module = PYTHON_MODULE_PATTERN.matcher(runCommand).replaceFirst("$1");
                    return entry.withValue((Yaml.Block)((Yaml.Scalar)entry.getValue()).withValue("uv run " + module));
                }
            }
            return super.visitMappingEntry(entry, (Object)ctx);
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable Yaml.Sequence.Entry visitSequenceEntry(Yaml.Sequence.Entry entry, ExecutionContext ctx) {
            if (this.transformPipCommands && entry.getBlock() instanceof Yaml.Mapping) {
                Yaml.Mapping mapping = (Yaml.Mapping)entry.getBlock();
                for (Yaml.Mapping.Entry mappingEntry : mapping.getEntries()) {
                    String runCommand;
                    if (!"run".equals(mappingEntry.getKey().getValue()) || !(mappingEntry.getValue() instanceof Yaml.Scalar) || !PIP_UPGRADE.matcher(runCommand = ((Yaml.Scalar)mappingEntry.getValue()).getValue()).matches()) continue;
                    return null;
                }
            }
            return super.visitSequenceEntry(entry, (Object)ctx);
        }
    }
}

