/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.apache.httpclient5;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.MethodCall;

public class UsernamePasswordCredentials
extends Recipe {
    private static final String FQN = "org.apache.http.auth.UsernamePasswordCredentials";
    private static final String METHOD_PATTERN = "org.apache.http.auth.UsernamePasswordCredentials <constructor>(String, String)";

    public String getDisplayName() {
        return "Migrate `UsernamePasswordCredentials` to httpclient5";
    }

    public String getDescription() {
        return "Change the password argument going into `UsernamePasswordCredentials` to be a `char[]`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher methodMatcher = new MethodMatcher(METHOD_PATTERN);
        return Preconditions.check((TreeVisitor)new UsesMethod(methodMatcher), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                J.NewClass nc = super.visitNewClass(newClass, (Object)ctx);
                if (methodMatcher.matches((MethodCall)nc)) {
                    Expression passwordArgument = (Expression)nc.getArguments().get(1);
                    nc = (J.NewClass)JavaTemplate.apply((String)"#{any(String)}.toCharArray()", (Cursor)this.getCursor(), (JavaCoordinates)passwordArgument.getCoordinates().replace(), (Object[])new Object[]{passwordArgument});
                }
                return nc;
            }
        });
    }
}

