/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractJavaJAXRSServerCodegen;
import org.openapitools.codegen.languages.features.DocumentationProviderFeatures;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationsMap;

public class JavaJerseyServerCodegen
extends AbstractJavaJAXRSServerCodegen {
    protected static final String LIBRARY_JERSEY2 = "jersey2";
    protected static final String LIBRARY_JERSEY3 = "jersey3";
    public static final String DEFAULT_JERSEY_LIBRARY = "jersey2";

    public JavaJerseyServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}));
        this.outputFolder = "generated-code/JavaJaxRS-Jersey";
        this.apiTemplateFiles.put("apiService.mustache", ".java");
        this.apiTemplateFiles.put("apiServiceImpl.mustache", ".java");
        this.apiTemplateFiles.put("apiServiceFactory.mustache", ".java");
        this.apiTestTemplateFiles.clear();
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        this.templateDir = "JavaJaxRS";
        this.embeddedTemplateDir = "JavaJaxRS";
        CliOption library = new CliOption("library", "library template (sub-template)").defaultValue("jersey2");
        this.supportedLibraries.put("jersey2", "Jersey core 2.x");
        this.supportedLibraries.put(LIBRARY_JERSEY3, "Jersey core 3.x");
        library.setEnum(this.supportedLibraries);
        this.cliOptions.add(library);
    }

    @Override
    public String getName() {
        return "jaxrs-jersey";
    }

    @Override
    public String getHelp() {
        return "Generates a Java JAXRS Server application based on Jersey framework.";
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if ("null".equals(property.example)) {
            property.example = null;
        }
        if (!BooleanUtils.toBoolean((Boolean)model.isEnum)) {
            model.imports.add("JsonProperty");
            if (BooleanUtils.toBoolean((Boolean)model.hasEnums)) {
                model.imports.add("JsonValue");
            }
        }
        if (this.isLibrary(LIBRARY_JERSEY3)) {
            model.imports.add("Schema");
        }
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (StringUtils.isEmpty((CharSequence)this.library)) {
            this.setLibrary("jersey2");
        } else if (this.isLibrary(LIBRARY_JERSEY3)) {
            this.setUseJakartaEe(true);
            this.additionalProperties.put("useJakartaEe", true);
            this.applyJakartaPackage();
            this.annotationLibrary = DocumentationProviderFeatures.AnnotationLibrary.SWAGGER2;
        }
        if (this.additionalProperties.containsKey("implFolder")) {
            this.implFolder = (String)this.additionalProperties.get("implFolder");
        }
        if ("joda".equals(this.dateLibrary)) {
            this.supportingFiles.add(new SupportingFile("JodaDateTimeProvider.mustache", (this.sourceFolder + "/" + this.apiPackage).replace(".", "/"), "JodaDateTimeProvider.java"));
            this.supportingFiles.add(new SupportingFile("JodaLocalDateProvider.mustache", (this.sourceFolder + "/" + this.apiPackage).replace(".", "/"), "JodaLocalDateProvider.java"));
        } else if (this.dateLibrary.startsWith("java8")) {
            this.supportingFiles.add(new SupportingFile("OffsetDateTimeProvider.mustache", (this.sourceFolder + "/" + this.apiPackage).replace(".", "/"), "OffsetDateTimeProvider.java"));
            this.supportingFiles.add(new SupportingFile("LocalDateProvider.mustache", (this.sourceFolder + "/" + this.apiPackage).replace(".", "/"), "LocalDateProvider.java"));
        }
        this.supportingFiles.add(new SupportingFile("pom.mustache", "", "pom.xml").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("ApiException.mustache", (this.sourceFolder + "/" + this.apiPackage).replace(".", "/"), "ApiException.java"));
        this.supportingFiles.add(new SupportingFile("ApiOriginFilter.mustache", (this.sourceFolder + "/" + this.apiPackage).replace(".", "/"), "ApiOriginFilter.java"));
        this.supportingFiles.add(new SupportingFile("ApiResponseMessage.mustache", (this.sourceFolder + "/" + this.apiPackage).replace(".", "/"), "ApiResponseMessage.java"));
        this.supportingFiles.add(new SupportingFile("NotFoundException.mustache", (this.sourceFolder + "/" + this.apiPackage).replace(".", "/"), "NotFoundException.java"));
        this.supportingFiles.add(new SupportingFile("jacksonJsonProvider.mustache", (this.sourceFolder + "/" + this.apiPackage).replace(".", "/"), "JacksonJsonProvider.java"));
        this.supportingFiles.add(new SupportingFile("RFC3339DateFormat.mustache", (this.sourceFolder + "/" + this.apiPackage).replace(".", "/"), "RFC3339DateFormat.java"));
        this.supportingFiles.add(new SupportingFile("bootstrap.mustache", (this.implFolder + "/" + this.apiPackage).replace(".", "/"), "Bootstrap.java").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("web.mustache", "src/main/webapp/WEB-INF", "web.xml").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("StringUtil.mustache", (this.sourceFolder + "/" + this.apiPackage).replace(".", "/"), "StringUtil.java"));
        this.openApiNullable = false;
    }

    @Override
    public ModelsMap postProcessModelsEnum(ModelsMap objs) {
        objs = super.postProcessModelsEnum(objs);
        List<Map<String, String>> imports = objs.getImports();
        for (ModelMap mo : objs.getModels()) {
            CodegenModel cm = mo.getModel();
            if (!Boolean.TRUE.equals(cm.isEnum) || cm.allowableValues == null) continue;
            cm.imports.add((String)this.importMapping.get("JsonValue"));
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("import", (String)this.importMapping.get("JsonValue"));
            imports.add(item);
        }
        return objs;
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        this.removeImport(objs, "java.util.List");
        return objs;
    }
}

