/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla.impl;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.regex.Pattern;
import mondrian.xmla.SaxWriter;
import org.olap4j.xmla.server.impl.ArrayStack;
import org.olap4j.xmla.server.impl.StringEscaper;
import org.olap4j.xmla.server.impl.Util;
import org.xml.sax.Attributes;

public class DefaultSaxWriter
implements SaxWriter {
    private static final int STATE_IN_TAG = 0;
    private static final int STATE_END_ELEMENT = 1;
    private static final int STATE_AFTER_TAG = 2;
    private static final int STATE_CHARACTERS = 3;
    private final Appendable buf;
    private int indent;
    private final String indentStr = "  ";
    private final ArrayStack<String> stack = new ArrayStack();
    private int state = 1;
    private static final Pattern nlPattern = Pattern.compile("\\r\\n|\\r|\\n");
    private static final Attributes EmptyAttributes = new Attributes(){

        public int getLength() {
            return 0;
        }

        public String getURI(int index) {
            return null;
        }

        public String getLocalName(int index) {
            return null;
        }

        public String getQName(int index) {
            return null;
        }

        public String getType(int index) {
            return null;
        }

        public String getValue(int index) {
            return null;
        }

        public int getIndex(String uri, String localName) {
            return 0;
        }

        public int getIndex(String qName) {
            return 0;
        }

        public String getType(String uri, String localName) {
            return null;
        }

        public String getType(String qName) {
            return null;
        }

        public String getValue(String uri, String localName) {
            return null;
        }

        public String getValue(String qName) {
            return null;
        }
    };

    public DefaultSaxWriter(OutputStream stream) {
        this(new BufferedWriter(new OutputStreamWriter(stream)));
    }

    public DefaultSaxWriter(OutputStream stream, String xmlEncoding) throws UnsupportedEncodingException {
        this(new BufferedWriter(new OutputStreamWriter(stream, xmlEncoding)));
    }

    public DefaultSaxWriter(Appendable buf) {
        this(buf, 0);
    }

    public DefaultSaxWriter(Appendable buf, int initialIndent) {
        this.buf = buf;
        this.indent = initialIndent;
    }

    private void _startElement(String namespaceURI, String localName, String qName, Attributes atts) throws IOException {
        this._checkTag();
        if (this.indent > 0) {
            this.buf.append(Util.nl);
        }
        for (int i = 0; i < this.indent; ++i) {
            this.buf.append("  ");
        }
        ++this.indent;
        this.buf.append('<');
        this.buf.append(qName);
        int length = atts.getLength();
        for (int i = 0; i < length; ++i) {
            String val = atts.getValue(i);
            if (val == null) continue;
            this.buf.append(' ');
            this.buf.append(atts.getQName(i));
            this.buf.append("=\"");
            StringEscaper.XML_NUMERIC_ESCAPER.appendEscapedString(val, this.buf);
            this.buf.append("\"");
        }
        this.state = 0;
        assert (qName != null);
        this.stack.add(qName);
    }

    private void _checkTag() throws IOException {
        if (this.state == 0) {
            this.state = 2;
            this.buf.append('>');
        }
    }

    private void _endElement() throws IOException {
        String qName = this.stack.pop();
        --this.indent;
        if (this.state == 0) {
            this.buf.append("/>");
        } else {
            if (this.state != 3) {
                this.buf.append(Util.nl);
                for (int i = 0; i < this.indent; ++i) {
                    this.buf.append("  ");
                }
            }
            this.buf.append("</");
            this.buf.append(qName);
            this.buf.append('>');
        }
        this.state = 1;
    }

    private void _characters(String s) throws IOException {
        this._checkTag();
        StringEscaper.XML_NUMERIC_ESCAPER.appendEscapedString(s, this.buf);
        this.state = 3;
    }

    public void characters(String s) {
        try {
            this._characters(s);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while appending XML", e);
        }
    }

    public void startSequence(String name, String subName) {
        if (name != null) {
            this.startElement(name);
        } else {
            this.stack.push(null);
        }
    }

    public void endSequence() {
        if (this.stack.peek() == null) {
            this.stack.pop();
        } else {
            this.endElement();
        }
    }

    public final void textElement(String name, Object data) {
        try {
            this._startElement(null, null, name, EmptyAttributes);
            this.characters(nlPattern.matcher(data.toString()).replaceAll(" "));
            this._endElement();
        }
        catch (IOException e) {
            throw new RuntimeException("Error while appending XML", e);
        }
    }

    public void element(String tagName, Object ... attributes) {
        this.startElement(tagName, attributes);
        this.endElement();
    }

    public void startElement(String tagName) {
        try {
            this._startElement(null, null, tagName, EmptyAttributes);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while appending XML", e);
        }
    }

    public void startElement(String tagName, Object ... attributes) {
        try {
            this._startElement(null, null, tagName, new StringAttributes(attributes));
        }
        catch (IOException e) {
            throw new RuntimeException("Error while appending XML", e);
        }
    }

    public void endElement() {
        try {
            this._endElement();
        }
        catch (IOException e) {
            throw new RuntimeException("Error while appending XML", e);
        }
    }

    public void startDocument() {
        if (this.stack.size() != 0) {
            throw new IllegalStateException("Document already started");
        }
    }

    public void endDocument() {
        if (this.stack.size() != 0) {
            throw new IllegalStateException("Document may have unbalanced elements");
        }
        this.flush();
    }

    public void completeBeforeElement(String tagName) {
        if (this.stack.indexOf(tagName) == -1) {
            return;
        }
        String currentTagName = this.stack.peek();
        while (!tagName.equals(currentTagName)) {
            try {
                this._endElement();
            }
            catch (IOException e) {
                throw new RuntimeException("Error while appending XML", e);
            }
            currentTagName = this.stack.peek();
        }
    }

    public void verbatim(String text) {
        try {
            this._checkTag();
            this.buf.append(text);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while appending XML", e);
        }
    }

    public void flush() {
        if (this.buf instanceof Writer) {
            try {
                ((Writer)this.buf).flush();
            }
            catch (IOException e) {
                throw new RuntimeException("Error while flushing XML", e);
            }
        }
    }

    public static class StringAttributes
    implements Attributes {
        private final Object[] strings;

        public StringAttributes(Object[] strings) {
            this.strings = strings;
        }

        public int getLength() {
            return this.strings.length / 2;
        }

        public String getURI(int index) {
            return null;
        }

        public String getLocalName(int index) {
            return null;
        }

        public String getQName(int index) {
            return (String)this.strings[index * 2];
        }

        public String getType(int index) {
            return null;
        }

        public String getValue(int index) {
            return StringAttributes.stringValue(this.strings[index * 2 + 1]);
        }

        public int getIndex(String uri, String localName) {
            return -1;
        }

        public int getIndex(String qName) {
            int count = this.strings.length / 2;
            for (int i = 0; i < count; ++i) {
                String string = (String)this.strings[i * 2];
                if (!string.equals(qName)) continue;
                return i;
            }
            return -1;
        }

        public String getType(String uri, String localName) {
            return null;
        }

        public String getType(String qName) {
            return null;
        }

        public String getValue(String uri, String localName) {
            return null;
        }

        public String getValue(String qName) {
            int index = this.getIndex(qName);
            if (index < 0) {
                return null;
            }
            return StringAttributes.stringValue(this.strings[index * 2 + 1]);
        }

        private static String stringValue(Object s) {
            return s == null ? null : s.toString();
        }
    }
}

