/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.doc.office;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.odftoolkit.odfdom.changes.MapHelper;
import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeValueTypeAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.number.DataStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberBooleanStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberCurrencyStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberDataStyleElementBase;
import org.odftoolkit.odfdom.dom.element.number.NumberDateStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberNumberStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberPercentageStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTextStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTimeStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StyleMapElement;
import org.odftoolkit.odfdom.dom.element.style.StylePageLayoutElement;
import org.odftoolkit.odfdom.dom.element.style.StyleStyleElement;
import org.odftoolkit.odfdom.dom.element.text.TextListStyleElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberBooleanStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberCurrencyStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberDateStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberPercentageStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberTextStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberTimeStyle;
import org.odftoolkit.odfdom.incubator.doc.office.OdfStylesBase;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStylePageLayout;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextListStyle;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class OdfOfficeAutomaticStyles
extends OdfStylesBase {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.OFFICE, "automatic-styles");
    private static final long serialVersionUID = -2925910664631016175L;
    private HashMap<String, OdfStylePageLayout> mPageLayouts;

    public OdfOfficeAutomaticStyles(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    protected OdfOfficeAutomaticStyles(OdfFileDom ownerDoc, OdfName elementName) {
        super(ownerDoc, elementName);
    }

    @Override
    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public OdfStyle newStyle(OdfStyleFamily styleFamily) {
        OdfFileDom dom = (OdfFileDom)this.ownerDocument;
        OdfStyle newStyle = dom.newOdfElement(OdfStyle.class);
        newStyle.setStyleFamilyAttribute(styleFamily.getName());
        newStyle.setStyleNameAttribute(this.newUniqueStyleName(styleFamily));
        OdfElement firstChild = this.getFirstChildElement();
        if (firstChild != null) {
            this.insertBefore((Node)((Object)newStyle), (Node)((Object)firstChild));
        } else {
            this.appendChild((Node)((Object)newStyle));
        }
        return newStyle;
    }

    @Override
    protected <T extends OdfElement> T getStylesElement(OdfFileDom dom, Class<T> clazz) throws Exception {
        OdfElement stylesRoot = dom.getRootElement();
        OdfOfficeAutomaticStyles contentBody = OdfElement.findFirstChildNode(OdfOfficeAutomaticStyles.class, (Node)((Object)stylesRoot));
        NodeList childs = contentBody.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node cur = childs.item(i);
            if (cur == null || !clazz.isInstance(cur)) continue;
            return (T)((Object)((OdfElement)((Object)cur)));
        }
        return null;
    }

    public OdfTextListStyle newListStyle() {
        return this.newListStyle(this.newUniqueStyleName(OdfStyleFamily.List));
    }

    public OdfStylePageLayout newPageLayout() {
        return this.newPageLayout(this.newUniqueStyleName(null));
    }

    public OdfStylePageLayout newPageLayout(String pageLayoutName) {
        OdfFileDom dom = (OdfFileDom)this.ownerDocument;
        OdfStylePageLayout newPageLayout = dom.newOdfElement(OdfStylePageLayout.class);
        newPageLayout.setStyleNameAttribute(pageLayoutName);
        this.appendChild((Node)((Object)newPageLayout));
        return newPageLayout;
    }

    public OdfTextListStyle newListStyle(String listStyleName) {
        OdfFileDom dom = (OdfFileDom)this.ownerDocument;
        OdfTextListStyle newStyle = dom.newOdfElement(OdfTextListStyle.class);
        newStyle.setStyleNameAttribute(listStyleName);
        OdfElement child = this.getFirstChildElement();
        if (child != null) {
            if (child instanceof StyleStyleElement) {
                while (child != null && child instanceof StyleStyleElement) {
                    child = OdfElement.getNextSiblingElement((Node)((Object)child));
                }
            }
            if (child != null) {
                OdfElement removeChild = child;
                while (!(removeChild == null || removeChild instanceof OdfTextListStyle && ((OdfTextListStyle)removeChild).getStyleNameAttribute().equals(listStyleName))) {
                    removeChild = OdfElement.getNextSiblingElement((Node)((Object)removeChild));
                }
                this.insertBefore((Node)((Object)newStyle), (Node)((Object)child));
                if (removeChild != null) {
                    this.removeChild((Node)((Object)removeChild));
                }
            } else {
                this.appendChild((Node)((Object)newStyle));
            }
        } else {
            this.appendChild((Node)((Object)newStyle));
        }
        return newStyle;
    }

    public OdfStylePageLayout getPageLayout(String name) {
        if (this.mPageLayouts != null) {
            return this.mPageLayouts.get(name);
        }
        return null;
    }

    public OdfStylePageLayout getOrCreatePageLayout(String name) {
        OdfStylePageLayout pageLayout = this.getPageLayout(name);
        if (pageLayout == null) {
            OdfFileDom dom = (OdfFileDom)this.ownerDocument;
            pageLayout = dom.newOdfElement(OdfStylePageLayout.class);
            pageLayout.setStyleNameAttribute(name);
            this.appendChild((Node)((Object)pageLayout));
        }
        return pageLayout;
    }

    @Override
    public void onOdfNodeInserted(OdfElement node, Node refNode) {
        if (node instanceof OdfStylePageLayout) {
            OdfStylePageLayout pageLayout = (OdfStylePageLayout)node;
            if (this.mPageLayouts == null) {
                this.mPageLayouts = new HashMap();
            }
            this.mPageLayouts.put(pageLayout.getStyleNameAttribute(), pageLayout);
        } else {
            super.onOdfNodeInserted(node, refNode);
        }
    }

    @Override
    public void onOdfNodeRemoved(OdfElement node) {
        if (node instanceof OdfStylePageLayout) {
            if (this.mPageLayouts != null) {
                OdfStylePageLayout pageLayout = (OdfStylePageLayout)node;
                this.mPageLayouts.remove(pageLayout.getStyleNameAttribute());
            }
        } else {
            super.onOdfNodeRemoved(node);
        }
    }

    public void optimize() {
        Iterator<OdfStyle> iter = this.getAllStyles().iterator();
        TreeSet<OdfStyle> stylesSet = new TreeSet<OdfStyle>();
        while (iter.hasNext()) {
            OdfStyle found;
            OdfStyle cur = iter.next();
            if (cur.getStyleUserCount() < 1) continue;
            SortedSet<OdfStyle> tail = stylesSet.tailSet(cur);
            OdfStyle odfStyle = found = tail.size() > 0 ? tail.first() : null;
            if (found != null && found.equals(cur)) {
                Iterator<OdfStylableElement> styleUsersIter = cur.getStyleUsers().iterator();
                ArrayList<OdfStylableElement> styleUsers = new ArrayList<OdfStylableElement>();
                while (styleUsersIter.hasNext()) {
                    styleUsers.add(styleUsersIter.next());
                }
                for (OdfStylableElement elem : styleUsers) {
                    OdfStyle autoStyle = elem.getAutomaticStyle();
                    if (autoStyle == null) continue;
                    elem.setStyleName(found.getStyleNameAttribute());
                }
                continue;
            }
            stylesSet.add(cur);
        }
        OdfStyle style = OdfElement.findFirstChildNode(OdfStyle.class, (Node)((Object)this));
        while (style != null) {
            OdfStyle nextStyle = OdfElement.findNextChildNode(OdfStyle.class, (Node)((Object)style));
            if (style.getStyleUserCount() < 1) {
                this.removeChild((Node)((Object)style));
            }
            style = nextStyle;
        }
    }

    public OdfStyle makeStyleUnique(OdfStyle referenceStyle) {
        OdfStyle newStyle = null;
        newStyle = referenceStyle.getOwnerDocument() != this.getOwnerDocument() ? (OdfStyle)((Object)this.getOwnerDocument().importNode((Node)((Object)referenceStyle), true)) : (OdfStyle)((Object)referenceStyle.cloneNode(true));
        newStyle.setStyleNameAttribute(this.newUniqueStyleName(newStyle.getFamily()));
        this.appendChild((Node)((Object)newStyle));
        return newStyle;
    }

    private String newUniqueStyleName(OdfStyleFamily styleFamily) {
        String unique_name;
        if (styleFamily != null && styleFamily.equals(OdfStyleFamily.List)) {
            while (this.getListStyle(unique_name = String.format("l%06x", (int)(Math.random() * 1.6777215E7))) != null) {
            }
        } else {
            while (this.getStyle(unique_name = String.format("a%06x", (int)(Math.random() * 1.6777215E7)), styleFamily) != null) {
            }
        }
        return unique_name;
    }

    private DataStyleElement createDataStyleElement(OfficeValueTypeAttribute.Value type, String numberFormatCode, String newDataStyleName) {
        OfficeValueTypeAttribute.Value t = type;
        if (t == OfficeValueTypeAttribute.Value.VOID) {
            t = MapHelper.detectFormatType(numberFormatCode);
        }
        if (t == OfficeValueTypeAttribute.Value.VOID) {
            return null;
        }
        OdfFileDom fileDom = (OdfFileDom)((Object)this.getOwnerDocument());
        NumberDataStyleElementBase newStyle = null;
        switch (t) {
            case DATE: {
                newStyle = new OdfNumberDateStyle(fileDom, numberFormatCode, newDataStyleName);
                break;
            }
            case BOOLEAN: {
                newStyle = new OdfNumberBooleanStyle(fileDom, newDataStyleName);
                break;
            }
            case CURRENCY: {
                newStyle = new OdfNumberCurrencyStyle(fileDom, numberFormatCode, newDataStyleName);
                break;
            }
            case FLOAT: {
                newStyle = new OdfNumberStyle(fileDom, numberFormatCode, newDataStyleName);
                break;
            }
            case PERCENTAGE: {
                newStyle = new OdfNumberPercentageStyle(fileDom, numberFormatCode, newDataStyleName);
                break;
            }
            case STRING: {
                newStyle = new OdfNumberTextStyle(fileDom, numberFormatCode, newDataStyleName);
                break;
            }
            case TIME: {
                newStyle = new OdfNumberTimeStyle(fileDom, numberFormatCode, newDataStyleName);
                break;
            }
        }
        return newStyle;
    }

    public DataStyleElement createDataStyle(OfficeValueTypeAttribute.Value type, String numberFormatCode, String newDataStyleName) {
        ArrayList<String> partArray = new ArrayList<String>();
        while (numberFormatCode.contains(";")) {
            int partStart = numberFormatCode.lastIndexOf(";", numberFormatCode.length());
            String part = numberFormatCode.substring(partStart + 1);
            partArray.add(0, part);
            numberFormatCode = numberFormatCode.substring(0, partStart);
        }
        partArray.add(0, numberFormatCode);
        DataStyleElement newStyle = this.createDataStyleElement(type, (String)partArray.get(partArray.size() - 1), newDataStyleName);
        if (partArray.size() > 1) {
            OdfFileDom fileDom = (OdfFileDom)((Object)this.getOwnerDocument());
            for (int partIndex = 0; partIndex < partArray.size() - 1; ++partIndex) {
                String partStyleName = newDataStyleName + "P" + partIndex;
                String part = (String)partArray.get(partIndex);
                DataStyleElement partStyle = this.createDataStyleElement(OfficeValueTypeAttribute.Value.VOID, part, partStyleName);
                Object condition = "value()";
                condition = (String)condition + (partArray.size() == 1 ? ">=0" : (partIndex == 0 ? ">0" : "<0"));
                StyleMapElement styleMap = fileDom.newOdfElement(StyleMapElement.class);
                styleMap.setStyleApplyStyleNameAttribute(partStyleName);
                styleMap.setStyleConditionAttribute((String)condition);
                newStyle.appendChild((Node)((Object)styleMap));
                partStyle.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:volatile", "true");
                this.appendChild((Node)((Object)partStyle));
            }
        }
        return (DataStyleElement)((Object)this.appendChild((Node)((Object)newStyle)));
    }

    public NumberBooleanStyleElement newNumberBooleanStyleElement(String styleNameValue) {
        NumberBooleanStyleElement numberBooleanStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberBooleanStyleElement.class);
        numberBooleanStyle.setStyleNameAttribute(styleNameValue);
        this.appendChild((Node)((Object)numberBooleanStyle));
        return numberBooleanStyle;
    }

    public NumberCurrencyStyleElement newNumberCurrencyStyleElement(String styleNameValue) {
        NumberCurrencyStyleElement numberCurrencyStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberCurrencyStyleElement.class);
        numberCurrencyStyle.setStyleNameAttribute(styleNameValue);
        this.appendChild((Node)((Object)numberCurrencyStyle));
        return numberCurrencyStyle;
    }

    public NumberDateStyleElement newNumberDateStyleElement(String styleNameValue) {
        NumberDateStyleElement numberDateStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberDateStyleElement.class);
        numberDateStyle.setStyleNameAttribute(styleNameValue);
        this.appendChild((Node)((Object)numberDateStyle));
        return numberDateStyle;
    }

    public NumberNumberStyleElement newNumberNumberStyleElement(String styleNameValue) {
        NumberNumberStyleElement numberNumberStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberNumberStyleElement.class);
        numberNumberStyle.setStyleNameAttribute(styleNameValue);
        this.appendChild((Node)((Object)numberNumberStyle));
        return numberNumberStyle;
    }

    public NumberPercentageStyleElement newNumberPercentageStyleElement(String styleNameValue) {
        NumberPercentageStyleElement numberPercentageStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberPercentageStyleElement.class);
        numberPercentageStyle.setStyleNameAttribute(styleNameValue);
        this.appendChild((Node)((Object)numberPercentageStyle));
        return numberPercentageStyle;
    }

    public NumberTextStyleElement newNumberTextStyleElement(String styleNameValue) {
        NumberTextStyleElement numberTextStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberTextStyleElement.class);
        numberTextStyle.setStyleNameAttribute(styleNameValue);
        this.appendChild((Node)((Object)numberTextStyle));
        return numberTextStyle;
    }

    public NumberTimeStyleElement newNumberTimeStyleElement(String styleNameValue) {
        NumberTimeStyleElement numberTimeStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberTimeStyleElement.class);
        numberTimeStyle.setStyleNameAttribute(styleNameValue);
        this.appendChild((Node)((Object)numberTimeStyle));
        return numberTimeStyle;
    }

    public StylePageLayoutElement newStylePageLayoutElement(String styleNameValue) {
        StylePageLayoutElement stylePageLayout = ((OdfFileDom)this.ownerDocument).newOdfElement(StylePageLayoutElement.class);
        stylePageLayout.setStyleNameAttribute(styleNameValue);
        this.appendChild((Node)((Object)stylePageLayout));
        return stylePageLayout;
    }

    public StyleStyleElement newStyleStyleElement(String styleFamilyValue, String styleNameValue) {
        StyleStyleElement styleStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(StyleStyleElement.class);
        styleStyle.setStyleFamilyAttribute(styleFamilyValue);
        styleStyle.setStyleNameAttribute(styleNameValue);
        this.appendChild((Node)((Object)styleStyle));
        return styleStyle;
    }

    public TextListStyleElement newTextListStyleElement(String styleNameValue) {
        TextListStyleElement textListStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(TextListStyleElement.class);
        textListStyle.setStyleNameAttribute(styleNameValue);
        this.appendChild((Node)((Object)textListStyle));
        return textListStyle;
    }

    @Override
    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }
}

