/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.doc.number;

import org.odftoolkit.odfdom.dom.attribute.number.NumberFormatSourceAttribute;
import org.odftoolkit.odfdom.dom.element.number.NumberAmPmElement;
import org.odftoolkit.odfdom.dom.element.number.NumberDateStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberDayElement;
import org.odftoolkit.odfdom.dom.element.number.NumberDayOfWeekElement;
import org.odftoolkit.odfdom.dom.element.number.NumberEraElement;
import org.odftoolkit.odfdom.dom.element.number.NumberHoursElement;
import org.odftoolkit.odfdom.dom.element.number.NumberMinutesElement;
import org.odftoolkit.odfdom.dom.element.number.NumberMonthElement;
import org.odftoolkit.odfdom.dom.element.number.NumberQuarterElement;
import org.odftoolkit.odfdom.dom.element.number.NumberSecondsElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTextElement;
import org.odftoolkit.odfdom.dom.element.number.NumberWeekOfYearElement;
import org.odftoolkit.odfdom.dom.element.number.NumberYearElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.w3c.dom.Node;

public class OdfNumberDateStyle
extends NumberDateStyleElement {
    private String styleName;
    private String calendarName;

    public OdfNumberDateStyle(OdfFileDom ownerDoc) {
        super(ownerDoc);
    }

    public OdfNumberDateStyle(OdfFileDom ownerDoc, String format, String styleName) {
        this(ownerDoc, format, styleName, null);
    }

    public OdfNumberDateStyle(OdfFileDom ownerDoc, String format, String styleName, String calendarName) {
        super(ownerDoc);
        this.styleName = styleName;
        this.calendarName = calendarName;
        this.setFormat(format);
    }

    @Override
    public String getFormat(boolean caps) {
        Object result = "";
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            String numberstyle;
            OdfElement ele;
            if (!(child instanceof OdfElement)) continue;
            if (child instanceof NumberDayElement) {
                ele = (NumberDayElement)((Object)child);
                numberstyle = ((NumberDayElement)ele).getNumberStyleAttribute();
                if (numberstyle != null && numberstyle.equals("long")) {
                    result = (String)result + (caps ? "DD" : "dd");
                    continue;
                }
                result = (String)result + (caps ? "D" : "d");
                continue;
            }
            if (child instanceof NumberMonthElement) {
                ele = (NumberMonthElement)((Object)child);
                numberstyle = ((NumberMonthElement)ele).getNumberStyleAttribute();
                if (((NumberMonthElement)ele).getNumberTextualAttribute().booleanValue()) {
                    if (numberstyle != null && numberstyle.equals("long")) {
                        result = (String)result + "MMMM";
                        continue;
                    }
                    result = (String)result + "MMM";
                    continue;
                }
                if (numberstyle != null && numberstyle.equals("long")) {
                    result = (String)result + "MM";
                    continue;
                }
                result = (String)result + "M";
                continue;
            }
            if (child instanceof NumberYearElement) {
                ele = (NumberYearElement)((Object)child);
                numberstyle = ((NumberYearElement)ele).getNumberStyleAttribute();
                if (numberstyle != null && numberstyle.equals("long")) {
                    result = (String)result + (caps ? "YYYY" : "yyyy");
                    continue;
                }
                result = (String)result + (caps ? "YY" : "yy");
                continue;
            }
            if (child instanceof NumberTextElement) {
                String content = child.getTextContent();
                if (content == null || content.equals("")) {
                    result = (String)result + " ";
                    continue;
                }
                result = (String)result + content;
                continue;
            }
            if (child instanceof NumberEraElement) {
                ele = (NumberEraElement)((Object)child);
                numberstyle = ((NumberEraElement)ele).getNumberStyleAttribute();
                if (numberstyle != null && numberstyle.equals("long")) {
                    result = (String)result + "GG";
                    continue;
                }
                result = (String)result + "G";
                continue;
            }
            if (child instanceof NumberHoursElement) {
                ele = (NumberHoursElement)((Object)child);
                numberstyle = ((NumberHoursElement)ele).getNumberStyleAttribute();
                if (numberstyle != null && numberstyle.equals("long")) {
                    result = (String)result + (caps ? "HH" : "hh");
                    continue;
                }
                result = (String)result + (caps ? "H" : "h");
                continue;
            }
            if (child instanceof NumberMinutesElement) {
                ele = (NumberMinutesElement)((Object)child);
                numberstyle = ((NumberMinutesElement)ele).getNumberStyleAttribute();
                if (numberstyle != null && numberstyle.equals("long")) {
                    result = (String)result + "mm";
                    continue;
                }
                result = (String)result + "m";
                continue;
            }
            if (child instanceof NumberSecondsElement) {
                ele = (NumberSecondsElement)((Object)child);
                numberstyle = ((NumberSecondsElement)ele).getNumberStyleAttribute();
                result = numberstyle != null && numberstyle.equals("long") ? (String)result + (caps ? "SS" : "ss") : (String)result + (caps ? "S" : "s");
                Integer decimals = ((NumberSecondsElement)ele).getNumberDecimalPlacesAttribute();
                if (decimals == null || decimals <= 0) continue;
                result = (String)result + ".";
                for (int i = 0; i < decimals; ++i) {
                    result = (String)result + "0";
                }
                continue;
            }
            if (child instanceof NumberQuarterElement) {
                ele = (NumberQuarterElement)((Object)child);
                numberstyle = ((NumberQuarterElement)ele).getNumberStyleAttribute();
                if (numberstyle != null && numberstyle.equals("long")) {
                    result = (String)result + "QQ";
                    continue;
                }
                result = (String)result + "Q";
                continue;
            }
            if (child instanceof NumberDayOfWeekElement) {
                ele = (NumberDayOfWeekElement)((Object)child);
                numberstyle = ((NumberDayOfWeekElement)ele).getNumberStyleAttribute();
                if (numberstyle != null && numberstyle.equals("long")) {
                    result = (String)result + "NNN";
                    continue;
                }
                result = (String)result + "NN";
                continue;
            }
            if (child instanceof NumberAmPmElement) {
                result = (String)result + "AM/PM";
                continue;
            }
            if (!(child instanceof NumberWeekOfYearElement)) continue;
            result = (String)result + "WW";
        }
        return result;
    }

    @Override
    public void setFormat(String format) {
        String actionChars = "GgYyQqMWwDdNnEeHhmSs";
        int actionCount = 0;
        Object textBuffer = "";
        boolean endQuote = false;
        int i = 0;
        this.setStyleNameAttribute(this.styleName);
        this.setNumberFormatSourceAttribute(NumberFormatSourceAttribute.Value.LANGUAGE.toString());
        while (i < format.length()) {
            char ch = format.charAt(i);
            if (actionChars.indexOf(ch) >= 0) {
                this.emitText((String)textBuffer);
                textBuffer = "";
                actionCount = 0;
                while (i < format.length() && format.charAt(i) == ch) {
                    ++actionCount;
                    ++i;
                }
                int decimalCount = 0;
                if (i < format.length() - 1 && format.charAt(i) == '.' && format.charAt(i + 1) == '0') {
                    decimalCount = 1;
                    i += 2;
                    while (i < format.length() && format.charAt(i) == '0') {
                        ++decimalCount;
                        ++i;
                    }
                }
                if (actionCount > 1 || ch != 'w' && ch != 'W') {
                    this.processChar(ch, actionCount, decimalCount);
                    continue;
                }
                textBuffer = (String)textBuffer + ch;
                continue;
            }
            if (ch == '\'') {
                endQuote = false;
                ++i;
                while (i < format.length() && !endQuote) {
                    ch = format.charAt(i);
                    if (ch == '\'') {
                        if (i + 1 < format.length() && format.charAt(i + 1) == '\'') {
                            ++i;
                            textBuffer = (String)textBuffer + "'";
                        } else {
                            endQuote = true;
                        }
                    } else {
                        textBuffer = (String)textBuffer + ch;
                    }
                    ++i;
                }
                continue;
            }
            if (ch == 'A' && format.startsWith("AM/PM", i)) {
                this.emitText((String)textBuffer);
                textBuffer = "";
                NumberAmPmElement ampm = new NumberAmPmElement((OdfFileDom)((Object)this.getOwnerDocument()));
                this.appendChild((Node)((Object)ampm));
                i += 5;
                continue;
            }
            textBuffer = (String)textBuffer + ch;
            ++i;
        }
        this.emitText((String)textBuffer);
    }

    private void processChar(char ch, int count, int decimalCount) {
        OdfFileDom ownerDoc = (OdfFileDom)((Object)this.getOwnerDocument());
        switch (ch) {
            case 'G': {
                NumberEraElement era = new NumberEraElement(ownerDoc);
                era.setNumberStyleAttribute(this.isLongIf(count > 3));
                if (this.calendarName != null) {
                    era.setNumberCalendarAttribute(this.calendarName);
                }
                this.appendChild((Node)((Object)era));
                break;
            }
            case 'Y': 
            case 'y': {
                NumberYearElement year = new NumberYearElement(ownerDoc);
                year.setNumberStyleAttribute(this.isLongIf(count > 3));
                if (this.calendarName != null) {
                    year.setNumberCalendarAttribute(this.calendarName);
                }
                this.appendChild((Node)((Object)year));
                break;
            }
            case 'Q': {
                NumberQuarterElement quarter = new NumberQuarterElement(ownerDoc);
                quarter.setNumberStyleAttribute(this.isLongIf(count > 2));
                if (this.calendarName != null) {
                    quarter.setNumberCalendarAttribute(this.calendarName);
                }
                this.appendChild((Node)((Object)quarter));
                break;
            }
            case 'M': {
                NumberMonthElement month = new NumberMonthElement(ownerDoc);
                month.setNumberTextualAttribute(count > 2);
                month.setNumberStyleAttribute(this.isLongIf(count % 2 == 0));
                if (this.calendarName != null) {
                    month.setNumberCalendarAttribute(this.calendarName);
                }
                this.appendChild((Node)((Object)month));
                break;
            }
            case 'W': 
            case 'w': {
                NumberWeekOfYearElement weekOfYear = new NumberWeekOfYearElement(ownerDoc);
                if (this.calendarName != null) {
                    weekOfYear.setNumberCalendarAttribute(this.calendarName);
                }
                this.appendChild((Node)((Object)weekOfYear));
                break;
            }
            case 'D': 
            case 'd': {
                if (count > 2) {
                    NumberDayOfWeekElement day = new NumberDayOfWeekElement(ownerDoc);
                    day.setNumberStyleAttribute(this.isLongIf(count > 3));
                    if (this.calendarName != null) {
                        day.setNumberCalendarAttribute(this.calendarName);
                    }
                    this.appendChild((Node)((Object)day));
                    break;
                }
                NumberDayElement day = new NumberDayElement(ownerDoc);
                day.setNumberStyleAttribute(this.isLongIf(count > 1));
                if (this.calendarName != null) {
                    day.setNumberCalendarAttribute(this.calendarName);
                }
                this.appendChild((Node)((Object)day));
                break;
            }
            case 'N': {
                NumberDayOfWeekElement dayOfWeek = new NumberDayOfWeekElement(ownerDoc);
                dayOfWeek.setNumberStyleAttribute(this.isLongIf(count > 3));
                if (count > 3) {
                    this.emitText(", ");
                }
                if (this.calendarName != null) {
                    dayOfWeek.setNumberCalendarAttribute(this.calendarName);
                }
                this.appendChild((Node)((Object)dayOfWeek));
                break;
            }
            case 'H': 
            case 'h': {
                NumberHoursElement hours = new NumberHoursElement(ownerDoc);
                hours.setNumberStyleAttribute(this.isLongIf(count > 1));
                this.appendChild((Node)((Object)hours));
                break;
            }
            case 'm': {
                NumberMinutesElement minutes = new NumberMinutesElement(ownerDoc);
                minutes.setNumberStyleAttribute(this.isLongIf(count > 1));
                this.appendChild((Node)((Object)minutes));
                break;
            }
            case 'S': 
            case 's': {
                NumberSecondsElement seconds = new NumberSecondsElement(ownerDoc);
                seconds.setNumberStyleAttribute(this.isLongIf(count > 1));
                if (decimalCount > 0) {
                    seconds.setNumberDecimalPlacesAttribute(decimalCount);
                }
                this.appendChild((Node)((Object)seconds));
            }
        }
    }

    private String isLongIf(boolean isLong) {
        return isLong ? "long" : "short";
    }
}

