package org.nuiton.wikitty.search;

import java.io.Serializable;

/**
 * Greater operator is used to build restriction containing "element &gt; value"
 * where element could be a Integer, a Float or a Date. <br>
 * <br>
 * For example, use: RestrictionHelper.less( myElement ,
 * RestrictionHelper.DATE_FORMAT.format(new Date()) )
 */
public class Greater extends BinaryOperator implements Serializable {

    // serialVersionUID is used for serialization.
    private static final long serialVersionUID = 1L;

    /**
     * Default constructor
     */
    public Greater() {
        super();
    }

    /**
     * Equality test based attributes values
     * 
     * @param value
     *            Value to compare
     */
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Greater)) {
            return false;
        }

        final Greater greater = (Greater) other;

        return super.equals(greater);
    }

    public int hashCode() {
        // equals use objects that are not constant through time
        // then, unable to create hashCode from those objects 
        // returning a constant hash-code
        return Greater.class.hashCode();
    }

}