package org.nuiton.wikitty.search;

import java.io.Serializable;

/**
 * EndsWith operator is used to build restriction containing "element like
 * *value" where element could be a String, a multimedia, a text or an xhtml
 * <br>
 * <br>
 * For example, use: RestrictionHelper.end( myElement , "value" )
 */
public class EndsWith extends BinaryOperator implements Serializable {

    // serialVersionUID is used for serialization.
    private static final long serialVersionUID = 1L;

    /**
     * Default constructor
     */
    public EndsWith() {
        super();
    }

    /**
     * Equality test based attributes values
     * 
     * @param value
     *            Value to compare
     */
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EndsWith)) {
            return false;
        }

        final EndsWith endsWith = (EndsWith) other;

        return super.equals(endsWith);
    }

    public int hashCode() {
        // equals use objects that are not constant through time
        // then, unable to create hashCode from those objects 
        // returning a constant hash-code
        return EndsWith.class.hashCode();
    }

}