package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class WikittyGroupHelper extends WikittyGroupImpl {

    private static final long serialVersionUID = 1375406597L;


    /**
     * This class is not instanciable, it's just helper
     */
    private WikittyGroupHelper() {
    }


    static public void setName(Wikitty w, String name) {
        w.setField(EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_NAME, name);
    }

    static public String getName(Wikitty w) {
        String result = w.getFieldAsString(EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_NAME);
        return result;
    }

    static public Set<String> getMembers(Wikitty w) {
        Set<String> result = w.getFieldAsSet(EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS, String.class);
        return result;
    }

    static public void addMembers(Wikitty w, String element) {
        w.addToField(EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS, element);
    }
    
    static public void removeMembers(Wikitty w, String element) {
        w.removeFromField(EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS, element);
    }
    
    static public void clearMembers(Wikitty w) {
        w.clearField(EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS);
    }


    /**
     * Check if wikitty has current extension
     */
    static public boolean isExtension(Wikitty w) {
        boolean result = w.hasExtension(EXT_WIKITTYGROUP);
        return result;
    }

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     */
    static public void addExtension(Wikitty w) {
        for (WikittyExtension ext : extensions) {
            w.addExtension(ext);
        }
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_NAME);
            Object f2 = w2.getFieldAsObject(EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS);
            Object f2 = w2.getFieldAsObject(EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //WikittyGroupHelper
