package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class TreeNodeAbstract extends BusinessEntityWikitty implements TreeNode {

    private static final long serialVersionUID = 1877636640L;

    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionTreeNode =
        new WikittyExtension(EXT_TREENODE, "1.0", null,
		    WikittyUtil.buildFieldMapExtension(
				"String name",
				"Wikitty parent",
				"String children[0-*] unique=true"));
    static {
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        // current after requires ones
        exts.add(extensionTreeNode);

        extensions = Collections.unmodifiableList(exts);
    }

	public TreeNodeAbstract() {
		super();
	}

    public TreeNodeAbstract(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public TreeNodeAbstract(Wikitty wi) {
		super(wi);
	}


    public void setName(String name) {
        Object oldValue = getField(EXT_TREENODE, FIELD_TREENODE_NAME);
        getWikitty().setField(EXT_TREENODE, FIELD_TREENODE_NAME, name);
        getPropertyChangeSupport().firePropertyChange(FIELD_TREENODE_NAME, oldValue, name);
    }

    public String getName() {
        String result = getWikitty().getFieldAsString(EXT_TREENODE, FIELD_TREENODE_NAME);
        return result;
    }


    public void setParent(String parent) {
        Object oldValue = getField(EXT_TREENODE, FIELD_TREENODE_PARENT);
        getWikitty().setField(EXT_TREENODE, FIELD_TREENODE_PARENT, parent);
        getPropertyChangeSupport().firePropertyChange(FIELD_TREENODE_PARENT, oldValue, parent);
    }

    public String getParent() {
        String result = getWikitty().getFieldAsString(EXT_TREENODE, FIELD_TREENODE_PARENT);
        return result;
    }

    public Set<String> getChildren() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_TREENODE, FIELD_TREENODE_CHILDREN, String.class);
        return result;
    }

    public void addChildren(String element) {
        getWikitty().addToField(EXT_TREENODE, FIELD_TREENODE_CHILDREN, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_TREENODE_CHILDREN, null, getChildren());
    }
    
    public void removeChildren(String element) {
        getWikitty().removeFromField(EXT_TREENODE, FIELD_TREENODE_CHILDREN, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_TREENODE_CHILDREN, null, getChildren());
    }
    
    public void clearChildren() {
        getWikitty().clearField(EXT_TREENODE, FIELD_TREENODE_CHILDREN);
        getPropertyChangeSupport().firePropertyChange(FIELD_TREENODE_CHILDREN, null, getChildren());
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_TREENODE, FIELD_TREENODE_NAME);
            Object f2 = w2.getFieldAsObject(EXT_TREENODE, FIELD_TREENODE_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_TREENODE, FIELD_TREENODE_PARENT);
            Object f2 = w2.getFieldAsObject(EXT_TREENODE, FIELD_TREENODE_PARENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_TREENODE, FIELD_TREENODE_CHILDREN);
            Object f2 = w2.getFieldAsObject(EXT_TREENODE, FIELD_TREENODE_CHILDREN);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //TreeNodeAbstract
