package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class LabelHelper extends LabelImpl {

    private static final long serialVersionUID = -1282429385L;


    /**
     * This class is not instanciable, it's just helper
     */
    private LabelHelper() {
    }

    static public Set<String> getLabels(Wikitty w) {
        Set<String> result = w.getFieldAsSet(EXT_LABEL, Label.FIELD_LABEL_LABELS, String.class);
        return result;
    }

    static public void addLabels(Wikitty w, String element) {
        w.addToField(EXT_LABEL, Label.FIELD_LABEL_LABELS, element);
    }
    
    static public void removeLabels(Wikitty w, String element) {
        w.removeFromField(EXT_LABEL, Label.FIELD_LABEL_LABELS, element);
    }
    
    static public void clearLabels(Wikitty w) {
        w.clearField(EXT_LABEL, Label.FIELD_LABEL_LABELS);
    }


    /**
     * Check if wikitty has current extension
     */
    static public boolean isExtension(Wikitty w) {
        boolean result = w.hasExtension(EXT_LABEL);
        return result;
    }

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     */
    static public void addExtension(Wikitty w) {
        for (WikittyExtension ext : extensions) {
            w.addExtension(ext);
        }
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_LABEL, Label.FIELD_LABEL_LABELS);
            Object f2 = w2.getFieldAsObject(EXT_LABEL, Label.FIELD_LABEL_LABELS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //LabelHelper
