package org.nuiton.web.tapestry5.services;

import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.internal.bindings.AbstractBinding;
import org.apache.tapestry5.ioc.Location;
import org.apache.tapestry5.ioc.Messages;

/**
 * From <a href="http://wiki.apache.org/tapestry/Tapestry5HowToAddMessageFormatBindingPrefix">Tapestry5HowTo</a>
 * <h2>Usage :</h2>
 * <pre>
 * ${format:key=value1,value2} or &lt;t:component t:parameter="format:key=value1,value2"&gt;
 * </pre>
 *
 * Created: 27 avr. 2010
 *
 * @see FormatBindingFactory
 * @author fdesbois
 * $Id: FormatBinding.java 5 2010-05-04 16:23:44Z fdesbois $
 */
public class FormatBinding extends AbstractBinding {

    private final Messages messages;
    private final boolean invariant;
    private final List<Binding> keyBindings;
    private final List<Binding> valueBindings;

    public FormatBinding(Location location, Messages messages, boolean invariant,
            ArrayList<Binding> keyBindings, List<Binding> valueBindings) {
        super(location);

        this.messages = messages;
        this.invariant = invariant;
        this.keyBindings = keyBindings;
        this.valueBindings = valueBindings;
    }

    public FormatBinding(Location location, Messages messages, boolean invariant, ArrayList<Binding> keyBindings) {
        super(location);

        this.messages = messages;
        this.invariant = invariant;
        this.keyBindings = keyBindings;
        this.valueBindings = null;
    }

    @Override
    public Object get() {
        String key = "";
        for (Binding keyBinding : keyBindings) {
            key += keyBinding.get();
        }

        if (null == valueBindings) {
            return messages.get(key);
        }

        List<Object> values = new ArrayList<Object>(valueBindings.size());
        for (Binding valueBinding : valueBindings) {
            values.add(valueBinding.get());
        }

        return messages.format(key, values.toArray());
    }

    @Override
    public boolean isInvariant() {
        return this.invariant;
    }

    @SuppressWarnings("unchecked")
    @Override
    public Class<?> getBindingType() {
        return String.class;
    }
}
