/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.security.actions;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.StringUtil;
import org.nuiton.web.SecurityTopiaPersistenceContext;
import org.nuiton.web.security.SecurityUser;
import org.nuiton.web.security.SecurityUserImpl;
import org.nuiton.web.security.SecurityUserTopiaDao;
import org.nuiton.web.security.actions.AbstractAction;

public class UserAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(UserAction.class);
    protected SecurityUserTopiaDao securityUserDAO;
    protected SecurityUser user;
    protected String password;
    protected String confirm;

    public SecurityUser getUser() {
        if (this.user == null) {
            String roleId = this.getParameter("userId");
            if (StringUtils.isNotBlank((CharSequence)roleId)) {
                SecurityTopiaPersistenceContext transaction = this.rootContext.newPersistenceContext();
                this.securityUserDAO = transaction.getSecurityUserDao();
                this.user = (SecurityUser)this.securityUserDAO.findByTopiaId(roleId);
                transaction.closeContext();
            } else {
                this.user = new SecurityUserImpl();
            }
        }
        return this.user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public String delete() throws Exception {
        block3: {
            try {
                String roleId = this.getParameter("userId");
                if (StringUtils.isNotBlank((CharSequence)roleId)) {
                    SecurityTopiaPersistenceContext transaction = this.rootContext.newPersistenceContext();
                    this.securityUserDAO = transaction.getSecurityUserDao();
                    SecurityUser user = (SecurityUser)this.securityUserDAO.findByTopiaId(roleId);
                    this.securityUserDAO.delete(user);
                    transaction.commit();
                    transaction.closeContext();
                }
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Can't delete user", (Throwable)ex);
            }
        }
        return "success";
    }

    public void validate() {
        if (StringUtils.isNotBlank((CharSequence)this.password) && !this.password.equals(this.confirm)) {
            this.addActionError(I18n.t((String)"Les mots de passes ne sont pas identiques !", (Object[])new Object[0]));
        }
    }

    public String execute() throws Exception {
        String result = super.execute();
        try {
            SecurityTopiaPersistenceContext transaction = this.rootContext.newPersistenceContext();
            this.securityUserDAO = transaction.getSecurityUserDao();
            SecurityUser user = this.getUser();
            if (StringUtils.isNotBlank((CharSequence)this.password)) {
                String md5Password = StringUtil.encodeMD5((String)this.password);
                user.setPassword(md5Password);
            }
            if (user.getTopiaId() == null) {
                this.securityUserDAO.create(user);
            } else {
                this.securityUserDAO.update(user);
            }
            transaction.commit();
            transaction.closeContext();
        }
        catch (Exception ex) {
            this.addActionError(ex.getMessage());
            result = this.input();
        }
        return result;
    }
}

