/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.security.actions;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.web.SecurityTopiaPersistenceContext;
import org.nuiton.web.security.SecurityRole;
import org.nuiton.web.security.SecurityRoleImpl;
import org.nuiton.web.security.SecurityRoleTopiaDao;
import org.nuiton.web.security.actions.AbstractAction;

public class RoleAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(RoleAction.class);
    protected SecurityRoleTopiaDao securityRoleDAO;
    protected SecurityRole role;

    public SecurityRole getRole() {
        if (this.role == null) {
            String roleId = this.getParameter("roleId");
            if (StringUtils.isNotBlank((CharSequence)roleId)) {
                SecurityTopiaPersistenceContext transaction = this.rootContext.newPersistenceContext();
                this.securityRoleDAO = transaction.getSecurityRoleDao();
                this.role = (SecurityRole)this.securityRoleDAO.findByTopiaId(roleId);
                transaction.closeContext();
            } else {
                this.role = new SecurityRoleImpl();
            }
        }
        return this.role;
    }

    public String delete() throws Exception {
        block3: {
            try {
                String roleId = this.getParameter("roleId");
                if (StringUtils.isNotBlank((CharSequence)roleId)) {
                    SecurityTopiaPersistenceContext transaction = this.rootContext.newPersistenceContext();
                    this.securityRoleDAO = transaction.getSecurityRoleDao();
                    SecurityRole role = (SecurityRole)this.securityRoleDAO.findByTopiaId(roleId);
                    this.securityRoleDAO.delete(role);
                    transaction.commit();
                    transaction.closeContext();
                }
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Can't delete role", (Throwable)ex);
            }
        }
        return "success";
    }

    public String execute() throws Exception {
        String result = super.execute();
        try {
            SecurityTopiaPersistenceContext transaction = this.rootContext.newPersistenceContext();
            this.securityRoleDAO = transaction.getSecurityRoleDao();
            if (this.getRole().getTopiaId() == null) {
                this.securityRoleDAO.create(this.getRole());
            } else {
                this.securityRoleDAO.update(this.getRole());
            }
            transaction.commit();
            transaction.closeContext();
        }
        catch (Exception ex) {
            this.addActionError(ex.getMessage());
            result = this.input();
        }
        return result;
    }
}

