/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.security;

import com.google.common.base.Function;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SubjectFactory;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.servlet.AbstractShiroFilter;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.apache.shiro.web.subject.WebSubject;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.topia.persistence.TopiaApplicationContextCache;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;
import org.nuiton.topia.persistence.util.TopiaUtil;
import org.nuiton.web.SecurityEntityEnum;
import org.nuiton.web.SecurityTopiaApplicationContext;
import org.nuiton.web.SecurityTopiaPersistenceContext;
import org.nuiton.web.security.SecuritySubjectFactory;
import org.nuiton.web.security.SecurityUser;
import org.nuiton.web.security.SecurityUserImpl;
import org.nuiton.web.security.SecurityUserTopiaDao;
import org.nuiton.web.security.SecurityUtil;
import org.nuiton.web.security.TopiaSecurityRealm;

public class SecurityShiroFilter
extends AbstractShiroFilter {
    private static final Log log = LogFactory.getLog(SecurityShiroFilter.class);
    public static final String APP_CONFIG_CONTEXT = SecurityShiroFilter.class.getName() + "#" + ApplicationConfig.class.getName();
    public static final String ROOT_CONTEXT_CONTEXT = SecurityShiroFilter.class.getName() + "#" + SecurityTopiaApplicationContext.class.getName();
    public static final String ANON_LOGIN = "anonymous";
    public static final String SESSION_REQUESTED_URL = "securityRequestedUrl";
    protected static final Function<Properties, SecurityTopiaApplicationContext> CREATE_SECURITY_APPLICATION_CONTEXT = new Function<Properties, SecurityTopiaApplicationContext>(){

        public SecurityTopiaApplicationContext apply(Properties input) {
            return new SecurityTopiaApplicationContext(input);
        }
    };
    protected ApplicationConfig config;
    protected SecurityTopiaApplicationContext rootContext;

    public void init() throws Exception {
        this.config = (ApplicationConfig)this.getServletContext().getAttribute(APP_CONFIG_CONTEXT);
        if (this.config == null) {
            throw new IllegalArgumentException("No APP_CONFIG_CONTEXT attribute found in servlet context");
        }
        this.config.setOption("topia.persistence.classes", SecurityEntityEnum.getImplementationClassesAsString());
        Properties props = this.config.getFlatOptions();
        this.rootContext = (SecurityTopiaApplicationContext)TopiaApplicationContextCache.getContext((Properties)props, CREATE_SECURITY_APPLICATION_CONTEXT);
        SecurityShiroFilter.initSchema(this.rootContext);
        this.getServletContext().setAttribute(ROOT_CONTEXT_CONTEXT, (Object)this.rootContext);
        if (log.isInfoEnabled()) {
            log.info((Object)"Overriding shiro realms");
        }
        TopiaSecurityRealm realm = new TopiaSecurityRealm(this.rootContext, this.config);
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager((Realm)realm);
        securityManager.setSubjectFactory((SubjectFactory)new SecuritySubjectFactory());
        securityManager.setSessionManager((SessionManager)new DefaultWebSessionManager());
        this.setSecurityManager((WebSecurityManager)securityManager);
        SecurityUtils.setSecurityManager((SecurityManager)securityManager);
    }

    protected static void initSchema(SecurityTopiaApplicationContext rootContext) throws TopiaException {
        SecurityTopiaPersistenceContext transaction = rootContext.newPersistenceContext();
        boolean testTable = TopiaUtil.isSchemaExist((TopiaHibernateSupport)transaction.getHibernateSupport(), (String)SecurityUserImpl.class.getName());
        transaction.closeContext();
        if (!testTable) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Create database schema");
            }
            rootContext.createSchema();
            SecurityTopiaPersistenceContext transaction2 = rootContext.newPersistenceContext();
            SecurityUserTopiaDao securityUserDAO = transaction2.getSecurityUserDao();
            SecurityUser anonUser = (SecurityUser)securityUserDAO.create();
            anonUser.setLogin(ANON_LOGIN);
            transaction2.commit();
            transaction2.closeContext();
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Table SecurityUser found, skip schema creation");
        }
    }

    protected void doFilterInternal(ServletRequest servletRequest, ServletResponse servletResponse, final FilterChain chain) throws ServletException, IOException {
        WebSubject subjectUser = this.createSubject(servletRequest, servletResponse);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Testing permission for user " + subjectUser.getPrincipal()));
        }
        if (subjectUser.getPrincipal() == null) {
            subjectUser.login((AuthenticationToken)new UsernamePasswordToken(ANON_LOGIN, ""));
        }
        String loginUrl = this.config.getOption("topia.security.loginurl");
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String contextPath = httpServletRequest.getContextPath();
        String uri = httpServletRequest.getRequestURI();
        if ((uri = uri.replaceFirst(";(jsessionid|JSESSIONID)=[\\w-]*", "")).startsWith(contextPath)) {
            uri = uri.substring(contextPath.length());
        }
        String perm = SecurityUtil.convertToShiroPerm(uri, this.config.getOption("topia.security.separators"));
        if (subjectUser.isPermitted("url" + perm)) {
            String referer;
            if (log.isDebugEnabled()) {
                log.debug((Object)("User is permitted to access " + perm));
            }
            Session session = subjectUser.getSession();
            if (uri.equals(loginUrl) && session.getAttribute((Object)SESSION_REQUESTED_URL) == null && (referer = httpServletRequest.getHeader("referer")) != null && !(referer = referer.replaceFirst(";(jsessionid|JSESSIONID)=[\\w-]*", "")).endsWith(loginUrl)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Remembering referer as " + referer));
                }
                session.setAttribute((Object)SESSION_REQUESTED_URL, (Object)referer);
            }
            final ServletRequest request = this.prepareServletRequest(servletRequest, servletResponse, chain);
            final ServletResponse response = this.prepareServletResponse(request, servletResponse, chain);
            subjectUser.execute(new Callable(){

                public Object call() throws Exception {
                    SecurityShiroFilter.this.updateSessionLastAccessTime(request, response);
                    SecurityShiroFilter.this.executeChain(request, response, chain);
                    return null;
                }
            });
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("User is NOT permitted to access " + perm));
            }
            if (subjectUser.isAuthenticated()) {
                ((HttpServletResponse)servletResponse).sendError(401, "Not authorized to access " + uri);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Redirecting user to login page");
                }
                Session session = subjectUser.getSession();
                StringBuffer requestURL = new StringBuffer(httpServletRequest.getRequestURL());
                if (httpServletRequest.getQueryString() != null) {
                    requestURL.append('?').append(httpServletRequest.getQueryString());
                }
                session.setAttribute((Object)SESSION_REQUESTED_URL, (Object)requestURL.toString());
                String redirect = contextPath + this.config.getOption("topia.security.loginurl");
                ((HttpServletResponse)servletResponse).sendRedirect(redirect);
            }
        }
    }

    public void destroy() {
        block3: {
            super.destroy();
            if (this.rootContext != null) {
                try {
                    this.rootContext.closeContext();
                }
                catch (TopiaException ex) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)"Can't close root context", (Throwable)ex);
                }
            }
        }
    }
}

