/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.servers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.rmi.Remote;
import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.service.TopiaApplicationServiceFactory;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.CodeVisitor;

public class RemoteClassLoader
implements ClassVisitor {
    private static final Log logger = LogFactory.getLog(RemoteClassLoader.class);
    public static final String EXTENSION = "Remote";
    protected ClassWriter cWriter;

    protected RemoteClassLoader() {
    }

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        this.cWriter = new ClassWriter(false);
        logger.debug((Object)("Converting class " + name + " as remote class"));
        String newSourceFileName = sourceFile.replaceAll("(.*)\\.java$", "$1Remote.java");
        String remoteInterface = Remote.class.getName().replaceAll("\\.", String.valueOf(File.separatorChar));
        String[] interfacesNew = null;
        if (interfaces == null) {
            interfacesNew = new String[]{remoteInterface};
        } else {
            interfacesNew = new String[interfaces.length + 1];
            for (int i = 0; i < interfaces.length; ++i) {
                interfacesNew[i] = interfaces[i];
            }
            interfacesNew[interfacesNew.length - 1] = remoteInterface;
        }
        this.cWriter.visit(version, access, name + EXTENSION, superName, interfacesNew, newSourceFileName);
    }

    public void visitAttribute(Attribute attr) {
        logger.warn((Object)("Attribute " + attr.toString() + " found : conversion not supported"));
    }

    public void visitEnd() {
        this.cWriter.visitEnd();
    }

    public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        logger.warn((Object)("Field " + name + " found : conversion not supported"));
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        logger.warn((Object)("InnerClass " + name + " found : conversion not supported"));
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        logger.debug((Object)("Processing method " + name));
        String remoteExceptionName = RemoteException.class.getName().replaceAll("\\.", String.valueOf(File.separatorChar));
        String[] exceptionsNew = null;
        if (exceptions == null) {
            exceptionsNew = new String[]{remoteExceptionName};
        } else {
            exceptionsNew = new String[exceptions.length + 1];
            for (int i = 0; i < exceptions.length; ++i) {
                exceptionsNew[i] = exceptions[i];
            }
            exceptionsNew[exceptionsNew.length - 1] = remoteExceptionName;
        }
        this.cWriter.visitMethod(access, name, desc, exceptionsNew, attrs);
        return null;
    }

    public static String getOriginClassName(Class clazz) {
        return clazz.getName().replaceAll("(.*)Remote$", "$1");
    }

    public static Class<?> getRemoteClass(Class clazz) throws ClassNotFoundException {
        Class<?> remoteClass = null;
        URL url = ClassLoader.getSystemClassLoader().getResource(clazz.getName().replaceAll("\\.", "/") + EXTENSION + ".class");
        if (url == null) {
            logger.debug((Object)("Remote class not found for '" + clazz.getName() + "', generating a new one"));
            RemoteClassLoader rcl = new RemoteClassLoader();
            byte[] clazzBytes = rcl.getClassData(clazz);
            try {
                rcl.saveOnDisk(clazz, clazzBytes);
            }
            catch (IOException e2) {
                logger.debug((Object)"Can't save generated class on disk", (Throwable)e2);
                throw new ClassNotFoundException("Can't find class : " + clazz.getName() + EXTENSION, e2);
            }
        }
        try {
            remoteClass = Class.forName(clazz.getName() + EXTENSION);
        }
        catch (ClassNotFoundException e2) {
            logger.debug((Object)"Can't find generated class", (Throwable)e2);
            throw new ClassNotFoundException("Can't find class : " + clazz.getName() + EXTENSION, e2);
        }
        return remoteClass;
    }

    protected void saveOnDisk(Class clazz, byte[] clazzBytes) throws IOException {
        URL originClazzPath = ClassLoader.getSystemClassLoader().getResource(clazz.getName().replaceAll("\\.", String.valueOf(File.separatorChar)) + ".class");
        String protocol = originClazzPath.getProtocol();
        if ("file".equals(protocol)) {
            this.saveInFile(originClazzPath, clazzBytes);
        } else if (protocol.matches("ear|jar|war|zip")) {
            this.saveInJarFile(originClazzPath, clazzBytes);
        } else {
            logger.warn((Object)("Unsupported protocol '" + protocol + "' for saving clazz."));
        }
    }

    protected void saveInJarFile(URL originClazzPath, byte[] clazzBytes) throws IOException {
        String path = originClazzPath.getFile().replaceAll("^file:(.*)!(.*)\\.class$", "$2Remote.class");
        File fRemoteClass = new File(TopiaApplicationServiceFactory.TOPIA_GENERATION_DIRECTORY + String.valueOf(File.separatorChar) + path);
        fRemoteClass.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(fRemoteClass);
        out.write(clazzBytes, 0, clazzBytes.length);
        out.close();
        logger.debug((Object)("Remote clazz saved into archive as path : " + fRemoteClass.getAbsolutePath()));
    }

    protected void saveInFile(URL originClazzPath, byte[] clazzBytes) throws IOException {
        String path = originClazzPath.getFile();
        path = path.replaceAll("\\.class$", "Remote.class");
        File f = new File(path);
        FileOutputStream out = new FileOutputStream(f);
        out.write(clazzBytes, 0, clazzBytes.length);
        out.close();
        logger.debug((Object)("Remote class saved to : " + path));
    }

    private byte[] getClassData(Class clazz) {
        byte[] b = null;
        try {
            ClassReader cr = new ClassReader(clazz.getName());
            cr.accept((ClassVisitor)this, false);
            b = this.cWriter.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return b;
    }
}

