/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.framework.TopiaUtil;
import org.nuiton.topia.service.Protocol;
import org.nuiton.topia.service.TopiaApplicationService;
import org.nuiton.topia.service.TopiaProxy;
import org.nuiton.topia.service.TopiaServiceProvider;
import org.nuiton.topia.service.clients.RMIProxy;
import org.nuiton.topia.service.clients.SOAPProxy;
import org.nuiton.topia.service.clients.XMLRPCProxy;

public class TopiaApplicationServiceFactory {
    public static final String DEFAULT_CONFIG_PROPERTIES = "TopiaContextImpl.properties";
    public static final String TOPIA_APPLICATION_SERVICE_BEGIN = "topia.application.service.";
    public static final String TOPIA_APPLICATION_PROVIDE_BEGIN = "topia.application.provide.";
    public static final String TOPIA_APPLICATION_SERVER_PORT_BEGIN = "topia.application.server.port.";
    public static String TOPIA_GENERATION_DIRECTORY = "topiagen";
    protected static Properties config;
    protected static final TopiaServiceProvider mainDispatcher;
    private static Map<Class<? extends TopiaApplicationService>, TopiaApplicationService> mapServiceCache;
    private static final Log log;
    protected static TopiaContext defaultServiceContext;

    static Properties getConfiguration() throws TopiaNotFoundException {
        if (config == null) {
            config = TopiaUtil.getProperties((String)DEFAULT_CONFIG_PROPERTIES);
        }
        return config;
    }

    public static void loadServices(Properties config, TopiaContext context) throws TopiaException {
        if (context == null) {
            throw new NullPointerException("I need a valid TopiaContext to initialise application services");
        }
        defaultServiceContext = context;
        if (config == null) {
            try {
                config = TopiaApplicationServiceFactory.getConfiguration();
            }
            catch (TopiaNotFoundException e) {
                throw new TopiaNotFoundException("Can't find configuration file TopiaContextImpl.properties");
            }
        }
        Set<Object> keySet = config.keySet();
        for (Object key : keySet) {
            String[] tabProtos;
            if (!key.toString().startsWith(TOPIA_APPLICATION_PROVIDE_BEGIN)) continue;
            String protos = config.getProperty(key.toString());
            String serviceClassName = ((String)key).replace(TOPIA_APPLICATION_PROVIDE_BEGIN, "");
            for (String proto : tabProtos = protos.split(",")) {
                Protocol protocol = Protocol.valueOf(proto.trim().replace('-', '_').toUpperCase());
                if (config.get(TOPIA_APPLICATION_SERVER_PORT_BEGIN + proto) != null) {
                    Integer port = null;
                    try {
                        port = Integer.valueOf((String)config.get(TOPIA_APPLICATION_SERVER_PORT_BEGIN + proto));
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)("Can't convert " + proto + " server port to integer"), (Throwable)e);
                    }
                    mainDispatcher.setProtocolPort(protocol, port);
                }
                try {
                    Class<?> serviceInterface = Class.forName(serviceClassName);
                    Class<?> serviceImplement = Class.forName(serviceClassName + "Impl");
                    try {
                        Object newInstance = serviceImplement.newInstance();
                        TopiaApplicationService service = (TopiaApplicationService)newInstance;
                        TopiaContext serviceContext = context.beginTransaction();
                        service.init(serviceContext);
                        TopiaApplicationServiceFactory.addService(serviceInterface, service, protocol);
                    }
                    catch (InstantiationException e) {
                        throw new TopiaException("Can't instanciate service class " + serviceImplement);
                    }
                    catch (IllegalAccessException e) {
                        throw new TopiaException("Can't access to service class " + serviceImplement);
                    }
                    log.info((Object)("service " + serviceClassName + " added for protocol " + proto));
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)("Class not found for " + serviceClassName), (Throwable)e);
                }
            }
        }
    }

    public static <E extends TopiaApplicationService> E getService(Class<E> serviceclazz) throws TopiaNotFoundException, TopiaException {
        TopiaApplicationService serviceimpl;
        block12: {
            serviceimpl = mapServiceCache.get(serviceclazz);
            if (serviceimpl != null) {
                return (E)serviceimpl;
            }
            Properties config = TopiaApplicationServiceFactory.getConfiguration();
            String serviceUrl = (String)config.get(TOPIA_APPLICATION_SERVICE_BEGIN + serviceclazz.getCanonicalName());
            if (serviceUrl == null) {
                log.error((Object)("Properties 'topia.application.service." + serviceclazz.getCanonicalName() + "' not found in configuration"));
                throw new TopiaNotFoundException("Service '" + serviceclazz.getCanonicalName() + "' not definided in configuration");
            }
            try {
                URI uriService = new URI(serviceUrl);
                String protocole = uriService.getScheme();
                String host = uriService.getHost();
                String fragment = uriService.getFragment();
                if ("local".equalsIgnoreCase(protocole)) {
                    String fqClassImpl = host;
                    log.debug((Object)("Trying to load local service : " + fqClassImpl));
                    try {
                        Class<?> resultClass = Class.forName(fqClassImpl);
                        serviceimpl = (TopiaApplicationService)resultClass.newInstance();
                        serviceimpl.init(defaultServiceContext.beginTransaction());
                        if (!"new".equalsIgnoreCase(fragment)) {
                            mapServiceCache.put(serviceclazz, serviceimpl);
                        }
                        break block12;
                    }
                    catch (ClassNotFoundException eee) {
                        throw new TopiaException("Can't find service class " + fqClassImpl);
                    }
                    catch (InstantiationException eee) {
                        throw new TopiaException("Can't instanciate service class " + fqClassImpl);
                    }
                    catch (IllegalAccessException eee) {
                        throw new TopiaException("Can't access service class " + fqClassImpl);
                    }
                }
                log.debug((Object)("Trying to get remote service : " + serviceUrl));
                TopiaProxy tProxy = TopiaApplicationServiceFactory.getProxyForURI(uriService);
                if (tProxy == null) {
                    log.debug((Object)("Unsupported protocole : " + protocole));
                } else {
                    tProxy.setURI(uriService);
                    tProxy.setClass(serviceclazz);
                    serviceimpl = (TopiaApplicationService)Proxy.newProxyInstance(serviceclazz.getClassLoader(), new Class[]{serviceclazz}, (InvocationHandler)tProxy);
                    mapServiceCache.put(serviceclazz, serviceimpl);
                }
            }
            catch (URISyntaxException e) {
                if (!log.isWarnEnabled()) break block12;
                log.warn((Object)("URI for service '" + serviceclazz.getCanonicalName() + "' is invalid !"), (Throwable)e);
            }
        }
        return (E)serviceimpl;
    }

    protected static TopiaProxy getProxyForURI(URI uriService) {
        TopiaProxy tProxy = null;
        if ("rmi".equalsIgnoreCase(uriService.getScheme())) {
            tProxy = new RMIProxy();
        } else if ("xml-rpc".equalsIgnoreCase(uriService.getScheme())) {
            tProxy = new XMLRPCProxy();
        } else if ("soap".equalsIgnoreCase(uriService.getScheme())) {
            tProxy = new SOAPProxy();
        }
        return tProxy;
    }

    public static void addService(Class<? extends TopiaApplicationService> interfaze, Class<? extends TopiaApplicationService> clazz, Protocol ... protocoles) {
        log.debug((Object)("Adding service for '" + interfaze + "' in protocoles : " + Arrays.toString((Object[])protocoles)));
        for (Protocol protocole : protocoles) {
            mainDispatcher.addServiceClass(interfaze, clazz, protocole);
        }
    }

    public static <E extends TopiaApplicationService> void addService(Class<E> interfaze, E instance, Protocol ... protocoles) {
        log.debug((Object)("Adding service for '" + interfaze + "'(unique instance) in protocoles : " + Arrays.toString((Object[])protocoles)));
        for (Protocol protocole : protocoles) {
            mainDispatcher.addServiceInstance(interfaze, instance, protocole);
        }
    }

    static {
        mainDispatcher = new TopiaServiceProvider();
        mapServiceCache = new HashMap<Class<? extends TopiaApplicationService>, TopiaApplicationService>();
        log = LogFactory.getLog(TopiaApplicationServiceFactory.class);
    }
}

