/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.sql.batch.actions;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.Target;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.service.sql.batch.actions.AbstractSchemaAction;
import org.nuiton.topia.service.sql.batch.actions.CreateSchemaRequest;

public class CreateSchemaAction
extends AbstractSchemaAction<CreateSchemaRequest> {
    public static final String CREATE_SCHEMA_STATEMENT = "CREATE SCHEMA %s;\n";

    public CreateSchemaAction(CreateSchemaRequest request) {
        super(request);
    }

    @Override
    protected String produceSql(Class<? extends Dialect> dialectType, Path temporaryDirectory) throws IOException {
        try {
            Path sqlScriptFile = temporaryDirectory.resolve("replicateSchema_" + System.nanoTime() + ".sql");
            Configuration hibernateConfiguration = this.getSourcePersistenceContext().getHibernateSupport().getHibernateConfiguration();
            Properties properties = new Properties();
            properties.put("hibernate.dialect", dialectType.getName());
            new SchemaExport(hibernateConfiguration, properties).setOutputFile(sqlScriptFile.toFile().getAbsolutePath()).setDelimiter(";").execute(Target.NONE, SchemaExport.Type.CREATE);
            String sqlStatements = "";
            if (((CreateSchemaRequest)this.request).isAddSchema()) {
                ImmutableSet<String> schemaNames = this.getSchemaNames();
                for (String schemaName : schemaNames) {
                    sqlStatements = sqlStatements + String.format(CREATE_SCHEMA_STATEMENT, schemaName);
                }
            }
            sqlStatements = sqlStatements + new String(Files.readAllBytes(sqlScriptFile));
            Files.delete(sqlScriptFile);
            return sqlStatements;
        }
        catch (HibernateException eee) {
            throw new TopiaException(String.format("Could not create schema for reason: %s", eee.getMessage()), (Throwable)eee);
        }
    }
}

