package org.nuiton.topia.security.entities.user;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaSecurityDAOHelper.TopiaSecurityEntityEnum;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

@Generated(value = "org.nuiton.topia.generator.EntityDAOTransformer", date = "Fri Apr 17 10:02:34 UTC 2015")
public abstract class TopiaUserDAOAbstract<E extends TopiaUser> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)TopiaUser.class;
    }

    @Override
    public TopiaSecurityEntityEnum getTopiaEntityEnum() {
        return TopiaSecurityEntityEnum.TopiaUser;
    }

    @Override
    public void delete(E entity) throws TopiaException {
        {
            List<TopiaGroup> list = getContext().getHibernate().createSQLQuery(
                    " SELECT main.*" +
                    " FROM topiaGroup main, topiagroup_topiauser secondary" +
                    " WHERE main.topiaid = secondary.topiaGroup" +
                    " AND secondary.topiaUser = ?")
                    .addEntity("main", org.nuiton.topia.TopiaSecurityDAOHelper.getImplementationClass(TopiaGroup.class))
                    .setString(0, entity.getTopiaId())
                    .list();

            for (TopiaGroup item : list) {
                item.removeTopiaUser(entity);
            }
        }

        super.delete(entity);
    }

    public E findByLogin(String v) throws TopiaException {
        E result = findByProperty(TopiaUser.PROPERTY_LOGIN, v);
        return result;
    }

    public List<E> findAllByLogin(String v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaUser.PROPERTY_LOGIN, v);
        return result;
    }

    public E findByEmail(String v) throws TopiaException {
        E result = findByProperty(TopiaUser.PROPERTY_EMAIL, v);
        return result;
    }

    public List<E> findAllByEmail(String v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaUser.PROPERTY_EMAIL, v);
        return result;
    }

    public E findByPassword(String v) throws TopiaException {
        E result = findByProperty(TopiaUser.PROPERTY_PASSWORD, v);
        return result;
    }

    public List<E> findAllByPassword(String v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaUser.PROPERTY_PASSWORD, v);
        return result;
    }

    public E findByNote(String v) throws TopiaException {
        E result = findByProperty(TopiaUser.PROPERTY_NOTE, v);
        return result;
    }

    public List<E> findAllByNote(String v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaUser.PROPERTY_NOTE, v);
        return result;
    }

    public E findByLinkApplication(String v) throws TopiaException {
        E result = findByProperty(TopiaUser.PROPERTY_LINK_APPLICATION, v);
        return result;
    }

    public List<E> findAllByLinkApplication(String v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaUser.PROPERTY_LINK_APPLICATION, v);
        return result;
    }

    public E findContainsTopiaGroup(TopiaGroup v) throws TopiaException {
        E result = findContains(TopiaUser.PROPERTY_TOPIA_GROUP, v);
        return result;
    }

    public List<E> findAllContainsTopiaGroup(TopiaGroup v) throws TopiaException {
        List<E> result = findAllContains(TopiaUser.PROPERTY_TOPIA_GROUP, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == TopiaGroup.class) {
            TopiaGroupDAO dao = (TopiaGroupDAO)
                getContext().getDAO(TopiaGroup.class);
            tmp = dao.findAllContainsTopiaUser(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(TopiaGroup.class, entity);
        if (!list.isEmpty()) {
            result.put(TopiaGroup.class, list);
        }

        return result;
    }

} //TopiaUserDAOAbstract<E extends TopiaUser>
