/*
 * #%L
 * ToPIA :: Service Security
 * 
 * $Id: PropertyWriteListener.java 2245 2011-04-14 12:47:09Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.6.3/topia-service-security/src/main/java/org/nuiton/topia/security/listener/PropertyWriteListener.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.security.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.security.TopiaSecurityServiceImpl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;

import static org.nuiton.topia.security.util.TopiaSecurityUtil.UPDATE;

/**
 * Listenner permettant de vérifier les autorisations pour le modification d'une
 * propriété sur une entités.
 *
 * @author ruchaud
 */
public class PropertyWriteListener implements VetoableChangeListener {

    private static Log log = LogFactory.getLog(PropertyWriteListener.class);

    private TopiaSecurityServiceImpl securityManager;

    public PropertyWriteListener(TopiaSecurityServiceImpl securityManager) {
        this.securityManager = securityManager;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
        Object source = event.getSource();
        TopiaEntityAbstract entity = (TopiaEntityAbstract) source;
        try {
            securityManager.checkPermission(entity.getTopiaId(), UPDATE);
        } catch (SecurityException te) {
            if (log.isWarnEnabled()) {
                log.warn("[Security] Write denied to : " + entity.getTopiaId(), te);
            }
            throw new SecurityException("Access denied to Write entity " + entity.getTopiaId() + " on " + event.getPropertyName(), te);
        }
    }

}
