package org.nuiton.topia.security.entities.user;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;


public  abstract class TopiaGroupDAOAbstract<E extends TopiaGroup> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)TopiaGroup.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        {
            List<TopiaUser> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from topiaUser main, topiagroup_topiauser secondary " +
                    "where main.topiaid=secondary.topiaUser" +
                    " and secondary.topiaGroup='" + entity.getTopiaId() + "'")
                    .addEntity("main", org.nuiton.topia.TopiaSecurityDAOHelper.getImplementationClass(TopiaUser.class)).list();

            for (TopiaUser item : list) {
                item.removeTopiaGroup(entity);
            }
        }

                                        {
                                        List<TopiaGroup> list = getContext()
                                                    .getDAO(TopiaGroup.class)
                                                    .findAllByProperties(TopiaGroup.SUPER_GROUP, entity);
                                            for (TopiaGroup item : list) {
                                                item.setSuperGroup(null);
                        
                    }
                }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(TopiaGroup.NAME, v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaGroup.NAME, v);
        return result;
    }

    /**
     * findByDescription :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut description le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByDescription(String v) throws TopiaException {
        E result = findByProperty(TopiaGroup.DESCRIPTION, v);
        return result;
    }

    /**
     * findAllByDescription :
     * Retourne les éléments ayant comme valeur pour l'attribut description le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByDescription(String v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaGroup.DESCRIPTION, v);
        return result;
    }

    /**
     * findContainsTopiaUser :
     * Retourne le premier élément ayant comme valeur pour l'attribut topiaUser le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsTopiaUser(TopiaUser v) throws TopiaException {
        E result = findContains(TopiaGroup.TOPIA_USER, v);
        return result;
    }

    /**
     * findAllContainsTopiaUser :
     * Retourne les éléments ayant comme valeur pour l'attribut topiaUser le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsTopiaUser(TopiaUser v) throws TopiaException {
        List<E> result = findAllContains(TopiaGroup.TOPIA_USER, v);
        return result;
    }

    /**
     * findBySuperGroup :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut superGroup le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findBySuperGroup(TopiaGroup v) throws TopiaException {
        E result = findByProperty(TopiaGroup.SUPER_GROUP, v);
        return result;
    }

    /**
     * findAllBySuperGroup :
     * Retourne les éléments ayant comme valeur pour l'attribut superGroup le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllBySuperGroup(TopiaGroup v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaGroup.SUPER_GROUP, v);
        return result;
    }

    /**
     * findContainsSubGroup :
     * Retourne le premier élément ayant comme valeur pour l'attribut subGroup le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsSubGroup(TopiaGroup v) throws TopiaException {
        E result = findContains(TopiaGroup.SUB_GROUP, v);
        return result;
    }

    /**
     * findAllContainsSubGroup :
     * Retourne les éléments ayant comme valeur pour l'attribut subGroup le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsSubGroup(TopiaGroup v) throws TopiaException {
        List<E> result = findAllContains(TopiaGroup.SUB_GROUP, v);
        return result;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == TopiaGroup.class) {
            TopiaGroupDAO dao = (TopiaGroupDAO)
                getContext().getDAO(TopiaGroup.class);
            tmp = dao.findAllBySuperGroup(entity);
            result.addAll(tmp);
        }

        if (type == TopiaGroup.class) {
            TopiaGroupDAO dao = (TopiaGroupDAO)
                getContext().getDAO(TopiaGroup.class);
            tmp = dao.findAllContainsSubGroup(entity);
            result.addAll(tmp);
        }

        if (type == TopiaUser.class) {
            TopiaUserDAO dao = (TopiaUserDAO)
                getContext().getDAO(TopiaUser.class);
            tmp = dao.findAllContainsTopiaGroup(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(TopiaGroup.class, entity);
        if (!list.isEmpty()) {
            result.put(TopiaGroup.class, list);
        }

        list = findUsages(TopiaUser.class, entity);
        if (!list.isEmpty()) {
            result.put(TopiaUser.class, list);
        }

        return result;
    }


} //TopiaGroupDAOAbstract<E extends TopiaGroup>
