package org.nuiton.topia.security.entities.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;


public  abstract class TopiaGroupAbstract extends TopiaEntityAbstract implements TopiaGroup {

    protected String name;
    protected String description;
    protected Collection<TopiaUser> topiaUser;
    protected TopiaGroup superGroup;
    protected Collection<TopiaGroup> subGroup;
    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, NAME, String.class, name);
        visitor.visit(this, DESCRIPTION, String.class, description);
        visitor.visit(this, TOPIA_USER, Collection.class, TopiaUser.class, topiaUser);
        visitor.visit(this, SUPER_GROUP, TopiaGroup.class, superGroup);
        visitor.visit(this, SUB_GROUP, Collection.class, TopiaGroup.class, subGroup);
        visitor.end(this);
}

    /**
     * setName :
     * @param name 
     */

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(NAME, oldValue, name);
}

    /**
     * getName :
     * @return String 
     */

    @Override
    public String getName() {
        fireOnPreRead(NAME, name);
        String result = this.name;
        fireOnPostRead(NAME, name);
        return result;
}

    /**
     * setDescription :
     * @param description 
     */

    @Override
    public void setDescription(String description) {
        String oldValue = this.description;
        fireOnPreWrite(DESCRIPTION, oldValue, description);
        this.description = description;
        fireOnPostWrite(DESCRIPTION, oldValue, description);
}

    /**
     * getDescription :
     * @return String 
     */

    @Override
    public String getDescription() {
        fireOnPreRead(DESCRIPTION, description);
        String result = this.description;
        fireOnPostRead(DESCRIPTION, description);
        return result;
}

    /**
     * addTopiaUser :
     * @param topiaUser 
     */

    @Override
    public void addTopiaUser(TopiaUser topiaUser) {
        fireOnPreWrite(TOPIA_USER, null, topiaUser);
        if (this.topiaUser == null) {
            this.topiaUser = new ArrayList<TopiaUser>();
        }

        if (topiaUser.getTopiaGroup() == null) {
            topiaUser.setTopiaGroup(new ArrayList<TopiaGroup>());
        }
        topiaUser.getTopiaGroup().add(this);

        this.topiaUser.add(topiaUser);
        fireOnPostWrite(TOPIA_USER, this.topiaUser.size(), null, topiaUser);
}

    /**
     * addAllTopiaUser :
     * @param topiaUser 
     */

    @Override
    public void addAllTopiaUser(Collection<TopiaUser> topiaUser) {
        if (topiaUser == null) {
            return;
        }
        for (TopiaUser item : topiaUser) {
            addTopiaUser(item);
        }
}

    /**
     * setTopiaUser :
     * @param topiaUser 
     */

    @Override
    public void setTopiaUser(Collection<TopiaUser> topiaUser) {
        // Copy elements to keep data for fire with new reference
        Collection<TopiaUser> oldValue = this.topiaUser != null ? new ArrayList<TopiaUser>(this.topiaUser) : null;
        fireOnPreWrite(TOPIA_USER, oldValue, topiaUser);
        this.topiaUser = topiaUser;
        fireOnPostWrite(TOPIA_USER, oldValue, topiaUser);
}

    /**
     * removeTopiaUser :
     * @param topiaUser 
     */

    @Override
    public void removeTopiaUser(TopiaUser topiaUser) {
        fireOnPreWrite(TOPIA_USER, topiaUser, null);
        if ((this.topiaUser == null) || (!this.topiaUser.remove(topiaUser))) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        topiaUser.getTopiaGroup().remove(this);

        fireOnPostWrite(TOPIA_USER, this.topiaUser.size() + 1, topiaUser, null);
}

    /**
     * clearTopiaUser :
     */

    @Override
    public void clearTopiaUser() {
        if (this.topiaUser == null) {
            return;
        }
        for (TopiaUser item : this.topiaUser) {
            item.getTopiaGroup().remove(this);
        }
        Collection<TopiaUser> oldValue = new ArrayList<TopiaUser>(this.topiaUser);
        fireOnPreWrite(TOPIA_USER, oldValue, this.topiaUser);
        this.topiaUser.clear();
        fireOnPostWrite(TOPIA_USER, oldValue, this.topiaUser);
}

    /**
     * getTopiaUser :
     * @return Collection<TopiaUser> 
     */

    @Override
    public Collection<TopiaUser> getTopiaUser() {
        return topiaUser;
}

    /**
     * getTopiaUserByTopiaId :
     * @param topiaId 
     * @return TopiaUser 
     */

    @Override
    public TopiaUser getTopiaUserByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(topiaUser, topiaId);
 }

    /**
     * sizeTopiaUser :
     * @return int 
     */

    @Override
    public int sizeTopiaUser() {
        if (topiaUser == null) {
            return 0;
        }
        return topiaUser.size();
}

    /**
     * isTopiaUserEmpty :
     * @return boolean 
     */

    @Override
    public boolean isTopiaUserEmpty() {
        int size = sizeTopiaUser();
        return size == 0;
}

    /**
     * setSuperGroup :
     * @param superGroup 
     */

    @Override
    public void setSuperGroup(TopiaGroup superGroup) {
        TopiaGroup oldValue = this.superGroup;
        fireOnPreWrite(SUPER_GROUP, oldValue, superGroup);
        this.superGroup = superGroup;
        fireOnPostWrite(SUPER_GROUP, oldValue, superGroup);
}

    /**
     * getSuperGroup :
     * @return TopiaGroup 
     */

    @Override
    public TopiaGroup getSuperGroup() {
        fireOnPreRead(SUPER_GROUP, superGroup);
        TopiaGroup result = this.superGroup;
        fireOnPostRead(SUPER_GROUP, superGroup);
        return result;
}

    /**
     * addSubGroup :
     * @param subGroup 
     */

    @Override
    public void addSubGroup(TopiaGroup subGroup) {
        fireOnPreWrite(SUB_GROUP, null, subGroup);
        if (this.subGroup == null) {
            this.subGroup = new ArrayList<TopiaGroup>();
        }

        subGroup.setSuperGroup(this);

        this.subGroup.add(subGroup);
        fireOnPostWrite(SUB_GROUP, this.subGroup.size(), null, subGroup);
}

    /**
     * addAllSubGroup :
     * @param subGroup 
     */

    @Override
    public void addAllSubGroup(Collection<TopiaGroup> subGroup) {
        if (subGroup == null) {
            return;
        }
        for (TopiaGroup item : subGroup) {
            addSubGroup(item);
        }
}

    /**
     * setSubGroup :
     * @param subGroup 
     */

    @Override
    public void setSubGroup(Collection<TopiaGroup> subGroup) {
        // Copy elements to keep data for fire with new reference
        Collection<TopiaGroup> oldValue = this.subGroup != null ? new ArrayList<TopiaGroup>(this.subGroup) : null;
        fireOnPreWrite(SUB_GROUP, oldValue, subGroup);
        this.subGroup = subGroup;
        fireOnPostWrite(SUB_GROUP, oldValue, subGroup);
}

    /**
     * removeSubGroup :
     * @param subGroup 
     */

    @Override
    public void removeSubGroup(TopiaGroup subGroup) {
        fireOnPreWrite(SUB_GROUP, subGroup, null);
        if ((this.subGroup == null) || (!this.subGroup.remove(subGroup))) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        subGroup.setSuperGroup(null);

        fireOnPostWrite(SUB_GROUP, this.subGroup.size() + 1, subGroup, null);
}

    /**
     * clearSubGroup :
     */

    @Override
    public void clearSubGroup() {
        if (this.subGroup == null) {
            return;
        }
        for (TopiaGroup item : this.subGroup) {
            item.setSuperGroup(null);
        }
        Collection<TopiaGroup> oldValue = new ArrayList<TopiaGroup>(this.subGroup);
        fireOnPreWrite(SUB_GROUP, oldValue, this.subGroup);
        this.subGroup.clear();
        fireOnPostWrite(SUB_GROUP, oldValue, this.subGroup);
}

    /**
     * getSubGroup :
     * @return Collection<TopiaGroup> 
     */

    @Override
    public Collection<TopiaGroup> getSubGroup() {
        return subGroup;
}

    /**
     * getSubGroupByTopiaId :
     * @param topiaId 
     * @return TopiaGroup 
     */

    @Override
    public TopiaGroup getSubGroupByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(subGroup, topiaId);
 }

    /**
     * sizeSubGroup :
     * @return int 
     */

    @Override
    public int sizeSubGroup() {
        if (subGroup == null) {
            return 0;
        }
        return subGroup.size();
}

    /**
     * isSubGroupEmpty :
     * @return boolean 
     */

    @Override
    public boolean isSubGroupEmpty() {
        int size = sizeSubGroup();
        return size == 0;
}

    /**
     * getAggregate :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
    }

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(NAME, this.name).
            append(DESCRIPTION, this.description).
         toString();
        return result;
}


} //TopiaGroupAbstract
