package org.nuiton.topia.security.entities.authorization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class TopiaAssociationAuthorizationDAOAbstract<E extends TopiaAssociationAuthorization> extends TopiaAuthorizationDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)TopiaAssociationAuthorization.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByIdBeginAssociation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut idBeginAssociation le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByIdBeginAssociation(String v) throws TopiaException {
        E result = findByProperty(TopiaAssociationAuthorization.ID_BEGIN_ASSOCIATION, v);
        return result;
    }

    /**
     * findAllByIdBeginAssociation :
     * Retourne les éléments ayant comme valeur pour l'attribut idBeginAssociation le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByIdBeginAssociation(String v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaAssociationAuthorization.ID_BEGIN_ASSOCIATION, v);
        return result;
    }

    /**
     * findByNameAssociation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut nameAssociation le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByNameAssociation(String v) throws TopiaException {
        E result = findByProperty(TopiaAssociationAuthorization.NAME_ASSOCIATION, v);
        return result;
    }

    /**
     * findAllByNameAssociation :
     * Retourne les éléments ayant comme valeur pour l'attribut nameAssociation le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByNameAssociation(String v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaAssociationAuthorization.NAME_ASSOCIATION, v);
        return result;
    }

    /**
     * findByActions :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut actions le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByActions(int v) throws TopiaException {
        E result = findByProperty(TopiaAssociationAuthorization.ACTIONS, v);
        return result;
    }

    /**
     * findAllByActions :
     * Retourne les éléments ayant comme valeur pour l'attribut actions le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByActions(int v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaAssociationAuthorization.ACTIONS, v);
        return result;
    }

    /**
     * findByPrincipals :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut principals le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByPrincipals(Set v) throws TopiaException {
        E result = findByProperty(TopiaAssociationAuthorization.PRINCIPALS, v);
        return result;
    }

    /**
     * findAllByPrincipals :
     * Retourne les éléments ayant comme valeur pour l'attribut principals le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByPrincipals(Set v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaAssociationAuthorization.PRINCIPALS, v);
        return result;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<?>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<?>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<?>, List<? extends TopiaEntity>>();
    }


} //TopiaAssociationAuthorizationDAOAbstract<E extends TopiaAssociationAuthorization>
