package org.nuiton.topia.security.entities.user;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class TopiaUserDAOAbstract<E extends TopiaUser> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)TopiaUser.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        {
            List<TopiaGroup> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from topiaGroup main, topiagroup_topiauser secondary " +
                    "where main.topiaid=secondary.topiaGroup" +
                    " and secondary.topiaUser='" + entity.getTopiaId() + "'")
                    .addEntity("main", org.nuiton.topia.TopiaSecurityDAOHelper.getImplementationClass(TopiaGroup.class)).list();

            for (TopiaGroup item : list) {
                item.removeTopiaUser(entity);
            }
        }

        super.delete(entity);
    }

    /**
     * findByLogin :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut login le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByLogin(String v) throws TopiaException {
        E result = findByProperty(TopiaUser.LOGIN, v);
        return result;
    }

    /**
     * findAllByLogin :
     * Retourne les éléments ayant comme valeur pour l'attribut login le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByLogin(String v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaUser.LOGIN, v);
        return result;
    }

    /**
     * findByEmail :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut email le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByEmail(String v) throws TopiaException {
        E result = findByProperty(TopiaUser.EMAIL, v);
        return result;
    }

    /**
     * findAllByEmail :
     * Retourne les éléments ayant comme valeur pour l'attribut email le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByEmail(String v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaUser.EMAIL, v);
        return result;
    }

    /**
     * findByPassword :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut password le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByPassword(String v) throws TopiaException {
        E result = findByProperty(TopiaUser.PASSWORD, v);
        return result;
    }

    /**
     * findAllByPassword :
     * Retourne les éléments ayant comme valeur pour l'attribut password le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByPassword(String v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaUser.PASSWORD, v);
        return result;
    }

    /**
     * findByNote :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut note le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByNote(String v) throws TopiaException {
        E result = findByProperty(TopiaUser.NOTE, v);
        return result;
    }

    /**
     * findAllByNote :
     * Retourne les éléments ayant comme valeur pour l'attribut note le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByNote(String v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaUser.NOTE, v);
        return result;
    }

    /**
     * findByLinkApplication :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut linkApplication le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByLinkApplication(String v) throws TopiaException {
        E result = findByProperty(TopiaUser.LINK_APPLICATION, v);
        return result;
    }

    /**
     * findAllByLinkApplication :
     * Retourne les éléments ayant comme valeur pour l'attribut linkApplication le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByLinkApplication(String v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaUser.LINK_APPLICATION, v);
        return result;
    }

    /**
     * findContainsTopiaGroup :
     * Retourne le premier élément trouvé dont l'attribut topiaGroup contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsTopiaGroup(TopiaGroup... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(TopiaUser.TOPIA_GROUP, Arrays.asList(v));
        E result = findContainsProperties("topiaGroup", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsTopiaGroup :
     * Retourne les éléments trouvé dont l'attribut topiaGroup contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsTopiaGroup(TopiaGroup... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(TopiaUser.TOPIA_GROUP, Arrays.asList(v));
        List<E> results = findAllContainsProperties("topiaGroup", Arrays.asList(v));
        return results;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == TopiaGroup.class) {
            TopiaGroupDAO dao = (TopiaGroupDAO)
                getContext().getDAO(TopiaGroup.class);
            tmp = dao.findAllContainsTopiaUser(entity);
//            tmp = dao.findAllByProperties(TopiaGroup.TOPIA_USER, entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);
        
        List<? extends TopiaEntity> list;

        list = findUsages(TopiaGroup.class, entity);
        if (!list.isEmpty()) {
            result.put(TopiaGroup.class, list);
        }

        return result;
    }


} //TopiaUserDAOAbstract<E extends TopiaUser>
