package org.nuiton.topia.taas.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class TaasPrincipalAbstract extends TopiaEntityAbstract implements TaasPrincipal {

    protected String name;
    protected Collection<TaasAuthorization> authorizations;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TaasPrincipal.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TaasPrincipal.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, NAME, String.class, name);
        visitor.visit(this, AUTHORIZATIONS, Collection.class, TaasAuthorization.class, authorizations);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite(NAME, _oldValue, value);
        this.name = value;
        fireOnPostWrite(NAME, _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead(NAME, name);
        String result = this.name;
        fireOnPostRead(NAME, name);
        return result;
}

    /**
     * addAuthorizations :
     * @param authorizations 
     */

    public void addAuthorizations(TaasAuthorization authorizations) {    
        fireOnPreWrite(AUTHORIZATIONS, null, authorizations);
        if (this.authorizations == null) {
            this.authorizations = new ArrayList<TaasAuthorization>();
        }
        this.authorizations.add(authorizations);
        fireOnPostWrite(AUTHORIZATIONS, this.authorizations.size(), null, authorizations);
}

    /**
     * addAllAuthorizations :
     * @param values 
     */

    public void addAllAuthorizations(Collection<TaasAuthorization> values) {
        if (values == null) {
            return;
        }
        for (TaasAuthorization item : values) {
            addAuthorizations(item);
        }
}

    /**
     * getAuthorizationsByTopiaId :
     * @param topiaId 
     * @return TaasAuthorization 
     */

    public TaasAuthorization getAuthorizationsByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(authorizations, topiaId);
 }

    /**
     * setAuthorizations :
     * @param values 
     */

    public void setAuthorizations(Collection<TaasAuthorization> values) {
        Collection<TaasAuthorization> _oldValue = authorizations;
        fireOnPreWrite(AUTHORIZATIONS, _oldValue, values);
        authorizations = values;
        fireOnPostWrite(AUTHORIZATIONS, _oldValue, values);
}

    /**
     * removeAuthorizations :
     * @param value 
     */

    public void removeAuthorizations(TaasAuthorization value) {
        fireOnPreWrite(AUTHORIZATIONS, value, null);
        if ((this.authorizations == null) || (!this.authorizations.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite(AUTHORIZATIONS, this.authorizations.size()+1, value, null);
}

    /**
     * clearAuthorizations :
     */

    public void clearAuthorizations() {
        if (this.authorizations == null) {
            return;
        }
        Collection<TaasAuthorization> _oldValue = new ArrayList<TaasAuthorization>(this.authorizations);
        fireOnPreWrite(AUTHORIZATIONS, _oldValue, this.authorizations);
        this.authorizations.clear();
        fireOnPostWrite(AUTHORIZATIONS, _oldValue, this.authorizations);
}

    /**
     * getAuthorizations :
     * @return Collection<TaasAuthorization> 
     */

    public Collection<TaasAuthorization> getAuthorizations() {
        return authorizations;
}

    /**
     * sizeAuthorizations :
     * @return int 
     */

    public int sizeAuthorizations() {
        if (authorizations == null) {
            return 0;
        }
        return authorizations.size();
}

    /**
     * isAuthorizationsEmpty :
     * @return boolean 
     */

    public boolean isAuthorizationsEmpty() {
        int size = sizeAuthorizations();
        return size == 0;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(NAME, this.name).
            append(AUTHORIZATIONS, this.authorizations).
         toString();
        return result;
}


} //TaasPrincipalAbstract
