package org.nuiton.topia.security.entities.user;

import java.util.List;


import java.util.Arrays;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;

/**
 * Implantation DAO pour l'entité TopiaUser.
 * Cette classe contient une implantation de TopiaDAO a laquel elle peut
 * deleguer des traitements
 * 
 */
public abstract class TopiaUserDAOAbstract<E extends TopiaUser> extends org.nuiton.topia.persistence.TopiaDAOImpl<E> implements org.nuiton.topia.persistence.TopiaDAO<E> {    

    public Class<E> getEntityClass() {
        return (Class<E>)TopiaUser.class;
    }

    public void delete(E entity) throws TopiaException {

        {
            List<org.nuiton.topia.security.entities.user.TopiaGroup> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from topiaGroup main, topiagroup_topiauser secondary " +
                    "where main.topiaid=secondary.topiaGroup" +
                    " and secondary.topiaUser='" + entity.getTopiaId() + "'")
                    .addEntity("main", org.nuiton.topia.TopiaSecurityDAOHelper.getImplementationClass(org.nuiton.topia.security.entities.user.TopiaGroup.class)).list();
            for (org.nuiton.topia.security.entities.user.TopiaGroup item : list) {
                item.removeTopiaUser(entity);
            }
        }
        
        super.delete(entity);
    }    
     
    /**
     * Recherche sur l'attribut login
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * login le paramètre
     * @param v la valeur que doit avoir login
     * @return un element ou null
     */
    public E findByLogin(java.lang.String v) throws TopiaException {
        E result = findByProperty("login", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * login le paramètre
     * @param v la valeur que doit avoir login
     * @return une liste
     */
    public List<E> findAllByLogin(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("login", v);
        return result;
    }
    /**
     * Recherche sur l'attribut email
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * email le paramètre
     * @param v la valeur que doit avoir email
     * @return un element ou null
     */
    public E findByEmail(java.lang.String v) throws TopiaException {
        E result = findByProperty("email", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * email le paramètre
     * @param v la valeur que doit avoir email
     * @return une liste
     */
    public List<E> findAllByEmail(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("email", v);
        return result;
    }
    /**
     * Recherche sur l'attribut password
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * password le paramètre
     * @param v la valeur que doit avoir password
     * @return un element ou null
     */
    public E findByPassword(java.lang.String v) throws TopiaException {
        E result = findByProperty("password", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * password le paramètre
     * @param v la valeur que doit avoir password
     * @return une liste
     */
    public List<E> findAllByPassword(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("password", v);
        return result;
    }
    /**
     * Recherche sur l'attribut note
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * note le paramètre
     * @param v la valeur que doit avoir note
     * @return un element ou null
     */
    public E findByNote(java.lang.String v) throws TopiaException {
        E result = findByProperty("note", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * note le paramètre
     * @param v la valeur que doit avoir note
     * @return une liste
     */
    public List<E> findAllByNote(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("note", v);
        return result;
    }
    /**
     * Recherche sur l'attribut linkApplication
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * linkApplication le paramètre
     * @param v la valeur que doit avoir linkApplication
     * @return un element ou null
     */
    public E findByLinkApplication(java.lang.String v) throws TopiaException {
        E result = findByProperty("linkApplication", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * linkApplication le paramètre
     * @param v la valeur que doit avoir linkApplication
     * @return une liste
     */
    public List<E> findAllByLinkApplication(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("linkApplication", v);
        return result;
    }
    /**
     * Recherche sur l'attribut topiaGroup
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * topiaGroup contient le paramètre
     * @param v la valeur que doit contenir topiaGroup
     * @return un element ou null
     */
    public E findContainsTopiaGroup(org.nuiton.topia.security.entities.user.TopiaGroup ... v) throws TopiaException {
        E result = findContainsProperties("topiaGroup", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * topiaGroup contient le paramètre
     * @param v la valeur que doit contenir topiaGroup
     * @return une liste
     */
    public List<E> findAllContainsTopiaGroup(org.nuiton.topia.security.entities.user.TopiaGroup ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("topiaGroup", Arrays.asList(v));
        return results;
    }

} // TopiaUserDAOAbstract
