/*
 * #%L
 * ToPIA :: Service Replication
 * 
 * $Id: TopiaReplicationOperationTest.java 2056 2010-07-09 14:16:44Z fdesbois $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.4/topia-service-replication/src/test/java/org/nuiton/topia/replication/TopiaReplicationOperationTest.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.replication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaTestDAOHelper.TopiaTestEntityEnum;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.replication.model.ReplicationOperationPhase;
import org.nuiton.topia.replication.operation.AttachAssociation;
import org.nuiton.topia.replication.operation.AttachDependency;
import org.nuiton.topia.replication.operation.DettachAssociation;
import org.nuiton.topia.replication.operation.DettachDependency;
import org.nuiton.topia.replication.operation.Duplicate;
import org.nuiton.topia.replication.operation.FakeOperation;
import org.nuiton.topia.replication.operation.UncreatableOperation;
import org.nuiton.topia.replication.operation.UnregistredOperation;
import org.nuiton.topia.test.entities.Person;
import org.nuiton.topia.test.entities.PersonImpl;
import org.nuiton.topia.test.entities.Pet;
import org.nuiton.topia.test.entities.PetImpl;
import org.nuiton.topia.test.entities.Race;
import org.nuiton.topia.test.entities.RaceImpl;

import java.io.File;
import java.util.Properties;

/**
 * ReplicationEngineTest on model TopiaTest
 * <p/>
 * Created: 07 jun. 09 17:14:22
 *
 * @author tchemit
 * @version $Revision: 2056 $
 *          <p/>
 *          Last update: $Date: 2010-07-09 16:16:44 +0200 (ven., 09 juil. 2010) $
 *          by : $Author: fdesbois $
 */
public class TopiaReplicationOperationTest extends AbstractReplicationEngineTest {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    private static final Log log = LogFactory.getLog(ReplicationEngineTest.class);

    protected static final TopiaEntityEnum[] contracts = {TopiaTestEntityEnum.Person, TopiaTestEntityEnum.Pet, TopiaTestEntityEnum.Race};

    protected static final String entitiesList = PersonImpl.class.getName() + "," + PetImpl.class.getName() + "," + RaceImpl.class.getName();

    static protected Person person, person2;

    static protected Pet pet, pet2;

    static protected Race race, race2;

    @AfterClass
    public static void after() throws Exception {
        AbstractReplicationEngineTest.after();
    }

    @Before
    @Override
    public void setUp() throws Exception {

        super.setUp();

        person = update(person);
        person2 = update(person2);
        pet = update(pet);
        pet2 = update(pet2);
        race = update(race);
        race2 = update(race2);
    }

    @After
    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        if (dstCtxt != null && !dstCtxt.isClosed()) {
            dstCtxt.closeContext();
        }
    }

//    @Ignore

    @Test(expected = NullPointerException.class)
    public void testGetOperation_nullOperationClass() throws Exception {
        service.getOperation(null);
    }

//    @Ignore

    @Test(expected = IllegalStateException.class)
    public void testGetOperation_serviceNotInit() throws Exception {
        ReplicationEngine.operations = null;
        try {
            new ReplicationEngine().getOperation(Duplicate.class);
        } catch (IllegalStateException e) {
            if (log.isErrorEnabled()) {
                log.error(e);
            }
            throw e;
        } finally {

            service.preInit((TopiaContextImplementor) context);
        }
    }

//    @Ignore

    @Test
    @Override
    public void testGetOperation() throws Exception {

        getOperation(UnregistredOperation.class, false);
        getOperation(UncreatableOperation.class, true);
        getOperation(FakeOperation.class, true);
        getOperation(Duplicate.class, true);
        getOperation(AttachAssociation.class, true);
        getOperation(DettachAssociation.class, true);
        getOperation(AttachDependency.class, true);
        getOperation(DettachDependency.class, true);
    }

//    @Ignore

    @Test(expected = NullPointerException.class)
    public void testCreateOperation_nullModel() throws Exception {
        service.createOperation(null, null, null, null);
    }

//    @Ignore

    @Test(expected = NullPointerException.class)
    public void testCreateOperation_nullType() throws Exception {

        model = service.createModel(contracts);
        service.createOperation(model, null, null, null);
    }

//    @Ignore

    @Test(expected = NullPointerException.class)
    public void testCreateOperation_nullPhase() throws Exception {

        model = service.createModel(contracts);
        service.createOperation(model, TopiaTestEntityEnum.Pet, null, null);
    }

//    @Ignore

    @Test(expected = NullPointerException.class)
    public void testCreateOperation_nullOperationClass() throws Exception {

        model = service.createModel(contracts);
        service.createOperation(model, TopiaTestEntityEnum.Pet, ReplicationOperationPhase.before, null);
    }

//    @Ignore

    @Test(expected = IllegalArgumentException.class)
    public void testCreateOperation_noNode() throws Exception {

        model = service.createModel(contracts);
        // le noeud Pet n'existe pas
        service.addAfterOperation(model, TopiaTestEntityEnum.Pet, Duplicate.class);
    }

//    @Ignore

    @Test(expected = IllegalArgumentException.class)
    public void testCreateOperation_noOperation() throws Exception {

        model = service.createModel(contracts);
        // le noeud Pet n'existe pas
        service.addAfterOperation(model, TopiaTestEntityEnum.Pet, UnregistredOperation.class);
    }

//    @Ignore

    @Test(expected = UnsupportedOperationException.class)
    public void testCreateUnsupportedBeforeOperation_Duplicate() throws Exception {
        createUnsupportedBeforeOperation(TopiaTestEntityEnum.Person, person, Duplicate.class);
    }

//    @Ignore

    @Test(expected = UnsupportedOperationException.class)
    public void testCreateUnsupportedBeforeOperation_AttachAssociation() throws Exception {
        createUnsupportedBeforeOperation(TopiaTestEntityEnum.Person, person, AttachAssociation.class);
    }

//    @Ignore

    @Test(expected = UnsupportedOperationException.class)
    public void testCreateUnsupportedBeforeOperation_DetachAssociation() throws Exception {
        createUnsupportedBeforeOperation(TopiaTestEntityEnum.Person, person, DettachAssociation.class);
    }

//    @Ignore

    @Test(expected = UnsupportedOperationException.class)
    public void testCreateUnsupportedBeforeOperation_AttachDependency() throws Exception {
        createUnsupportedBeforeOperation(TopiaTestEntityEnum.Person, person, AttachDependency.class);
    }

//    @Ignore

    @Test(expected = UnsupportedOperationException.class)
    public void testCreateUnsupportedBeforeOperation_DetachDependency() throws Exception {
        createUnsupportedBeforeOperation(TopiaTestEntityEnum.Person, person, DettachDependency.class);
    }

//    @Ignore

    @Test(expected = UnsupportedOperationException.class)
    public void testCreateUnsupportedAfterOperation_Duplicate() throws Exception {
        createUnsupportedAfterOperation(TopiaTestEntityEnum.Person, person, Duplicate.class);
    }

//    @Ignore

    @Test(expected = UnsupportedOperationException.class)
    public void testCreateUnsupportedAfterOperation_AttachAssociation() throws Exception {
        createUnsupportedAfterOperation(TopiaTestEntityEnum.Person, person, AttachAssociation.class);
    }

//    @Ignore

    @Test(expected = UnsupportedOperationException.class)
    public void testCreateUnsupportedAfterOperation_DetachAssociation() throws Exception {
        createUnsupportedAfterOperation(TopiaTestEntityEnum.Person, person, DettachAssociation.class);
    }

//    @Ignore

    @Test(expected = UnsupportedOperationException.class)
    public void testCreateUnsupportedAfterOperation_AttachDependency() throws Exception {
        createUnsupportedAfterOperation(TopiaTestEntityEnum.Person, person, AttachDependency.class);
    }

//    @Ignore

    @Test(expected = UnsupportedOperationException.class)
    public void testCreateUnsupportedAfterOperation_DetachDependency() throws Exception {
        createUnsupportedAfterOperation(TopiaTestEntityEnum.Person, person, DettachDependency.class);
    }

//    @Ignore

    @Test(expected = UnsupportedOperationException.class)
    public void testCreateUnsupportedBeforeOperation_UncreatableOperation() throws Exception {
        createUnsupportedBeforeOperation(TopiaTestEntityEnum.Person, person, UncreatableOperation.class);
    }

//    @Ignore

    @Test(expected = UnsupportedOperationException.class)
    public void testCreateUnsupportedAfterOperation_UncreatableOperation() throws Exception {
        createUnsupportedAfterOperation(TopiaTestEntityEnum.Person, person, UncreatableOperation.class);
    }

//    @Ignore

    @Test(expected = IllegalArgumentException.class)
    public void testCreateOperation_wrongParameterNumber() throws Exception {

        model = service.createModel(contracts, pet.getTopiaId());
        service.addBeforeOperation(model, TopiaTestEntityEnum.Pet, FakeOperation.class);
    }

//    @Ignore

    @Test(expected = IllegalArgumentException.class)
    public void testCreateOperation_wrongParameterNumber2() throws Exception {

        model = service.createModel(contracts, pet.getTopiaId());
        service.addBeforeOperation(model, TopiaTestEntityEnum.Pet, FakeOperation.class, String.class, String.class);
    }

//    @Ignore

    @Test(expected = IllegalArgumentException.class)
    public void testCreateOperation_wrongParameterType() throws Exception {

        model = service.createModel(contracts, pet.getTopiaId());
        service.addBeforeOperation(model, TopiaTestEntityEnum.Pet, FakeOperation.class, Integer.class);
    }

//    @Ignore

    @Test(expected = IllegalArgumentException.class)
    public void testCreateOperation_nullParameter() throws Exception {

        model = service.createModel(contracts, pet.getTopiaId());
        service.addBeforeOperation(model, TopiaTestEntityEnum.Pet, FakeOperation.class, (Object) null);
    }

//    @Ignore

    @Test
    public void testCreateOperation() throws Exception {

        model = service.createModel(contracts, pet.getTopiaId());
        service.addBeforeOperation(model, TopiaTestEntityEnum.Pet, FakeOperation.class, "before");
        service.addAfterOperation(model, TopiaTestEntityEnum.Race, FakeOperation.class, "after");
    }

//    @Ignore

    @Test(expected = NullPointerException.class)
    public void testDoReplicate_nullModel() throws Exception {

        service.doReplicate(null, null);
    }

//    @Ignore

    @Test(expected = NullPointerException.class)
    public void testDoReplicate_nullDstCtxt() throws Exception {

        model = service.createModel(contracts);
        service.doReplicate(model, null);
    }

    @Override
    protected TopiaContext createDb(String name) throws Exception {

        File localDB = new File(getTestDir(getClass()), "db_" + name);

        Properties config = getH2Properties(localDB);

        context = TopiaContextFactory.getContext(config);

        TopiaContextImplementor tx = (TopiaContextImplementor) context.beginTransaction();

        person = tx.getDAO(Person.class).create(Person.PROPERTY_NAME, "pudding master");
        race = tx.getDAO(Race.class).create(Race.PROPERTY_NAME, "race I");
        pet = tx.getDAO(Pet.class).create(Pet.PROPERTY_NAME, "pudding", Pet.PROPERTY_PERSON, person, Pet.PROPERTY_RACE, race);

        person2 = tx.getDAO(Person.class).create(Person.PROPERTY_NAME, "pudding II master");
        pet2 = tx.getDAO(Pet.class).create(Pet.PROPERTY_NAME, "pudding II");
        race2 = tx.getDAO(Race.class).create(Race.PROPERTY_NAME, "race II");

        tx.commitTransaction();
        tx.closeContext();
        return context;
    }

    @Override
    protected TopiaEntityEnum[] getContracts() {
        return contracts;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    protected Properties getH2Properties(File f) {

        Properties config = new Properties();
        config.setProperty("hibernate.show_sql", "false");
        config.setProperty("hibernate.hbm2ddl.auto", "create");

        config.setProperty("topia.persistence.classes", entitiesList);
        config.setProperty("hibernate.dialect", "org.hibernate.dialect.H2Dialect");
        config.setProperty("hibernate.connection.driver_class", "org.h2.Driver");
        config.setProperty("hibernate.connection.url", "jdbc:h2:file:" + f.getAbsolutePath() + ";create=true");
        config.setProperty("hibernate.connection.username", "sa");
        config.setProperty("hibernate.connection.password", "");

        config.setProperty("topia.service.replication", ReplicationEngine.class.getName());

        return config;
    }

    @Override
    protected TopiaContext createDb2(String name) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void testDetectTypes() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void testDetectAssociations() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void testDetectDirectDependencies() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void testDetectShell() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void testDetectDependencies() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void testDetectObjectsToDettach() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void testDetectOperations() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void testDoReplicate() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}


