/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.migration;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaPersistenceContext;
import org.nuiton.topia.persistence.support.TopiaSqlSupport;
import org.nuiton.util.StringUtil;
import org.nuiton.util.Version;

public abstract class AbstractTopiaMigrationCallback<PersistenceContext extends TopiaPersistenceContext> {
    private static final Log log = LogFactory.getLog(AbstractTopiaMigrationCallback.class);

    public abstract Version[] getAvailableVersions();

    public abstract boolean askUser(Version var1, List<Version> var2);

    protected abstract TopiaSqlSupport getSqlSupport(PersistenceContext var1);

    protected abstract void migrateForVersion(Version var1, PersistenceContext var2, boolean var3, boolean var4) throws Exception;

    public boolean doMigration(TopiaApplicationContext<PersistenceContext> applicationContext, Version dbVersion, boolean showSql, boolean showProgression, List<Version> versions) {
        boolean doMigrate = this.askUser(dbVersion, versions);
        if (doMigrate) {
            for (Version v : versions) {
                try {
                    TopiaPersistenceContext persistenceContext = applicationContext.newPersistenceContext();
                    try {
                        log.info((Object)String.format("Start migration to version %s", v));
                        this.migrateForVersion(v, persistenceContext, showSql, showProgression);
                        persistenceContext.commit();
                    }
                    catch (Exception eee) {
                        log.error((Object)"Could not migrate database", (Throwable)eee);
                        persistenceContext.rollback();
                        throw eee;
                    }
                    finally {
                        if (persistenceContext == null) continue;
                        persistenceContext.closeContext();
                    }
                }
                catch (Exception eee) {
                    log.error((Object)"Error lors de la tentative de migration", (Throwable)eee);
                    doMigrate = false;
                    break;
                }
            }
        }
        return doMigrate;
    }

    public void executeSQL(PersistenceContext tx, String ... sqls) throws TopiaException {
        this.executeSQL(tx, false, false, sqls);
    }

    public void executeSQL(PersistenceContext tx, boolean showSql, boolean showProgression, String ... sqls) throws TopiaException {
        TopiaSqlSupport sqlSupport = this.getSqlSupport(tx);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Will execute %1$s requests...", sqls.length));
        }
        if (showSql) {
            StringBuilder buffer = new StringBuilder();
            for (String s : sqls) {
                buffer.append(s).append("\n");
            }
            log.info((Object)("SQL TO EXECUTE :\n--------------------------------------------------------------------------------\n--------------------------------------------------------------------------------\n" + buffer.toString() + "--------------------------------------------------------------------------------\n" + "--------------------------------------------------------------------------------\n"));
        }
        int index = 0;
        int max = sqls.length;
        for (String sql : sqls) {
            String message;
            ++index;
            long t0 = System.nanoTime();
            if (log.isInfoEnabled()) {
                message = "";
                if (showProgression) {
                    message = String.format("Executing request [%1$-4s/%2$-4s]", index, max);
                }
                if (showSql) {
                    message = message + "\n" + sql;
                }
                if (showProgression || showSql) {
                    log.info((Object)message);
                }
            }
            sqlSupport.executeSql(sql);
            if (!log.isDebugEnabled()) continue;
            message = String.format("Request [%1$-4s/%2$-4s] executed in %3$s.", index, max, StringUtil.convertTime((long)(System.nanoTime() - t0)));
            log.debug((Object)message);
        }
    }
}

