/*
 * #%L
 * ToPIA :: Service Migration
 * 
 * $Id: Version.java 1894 2010-04-15 15:44:51Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.3.4/topia-service-migration/src/main/java/org/nuiton/topia/migration/common/Version.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.migration.common;

import java.util.StringTokenizer;

/**
 * Version.java
 *
 * Les version, de la forme "x.x.x".
 * Permet les comparaisons.
 * 
 * @author Chatellier Eric
 * @author Chevallereau Benjamin
 * @author Eon Sébastien
 * @author Trève Vincent
 * @version $Revision: 1894 $
 *
 * Last update : $Date: 2010-04-15 17:44:51 +0200 (jeu., 15 avril 2010) $
 * @deprecated since 2.2.0, prefer use {@link org.nuiton.util.Version}
 */
@Deprecated
public class Version implements Comparable<Version> {

    /**
     * La version
     */
    private String value;
    /**
     * Version V0
     */
    public static final Version VZERO = new Version("0");

    /**
     * Constructeur vide
     */
    public Version() {
        value = "";
    }

    /**
     * Constructeur avec version
     * @param value
     */
    public Version(String value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            return compareTo((Version) obj) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Version other) {
        StringTokenizer tokOther = new StringTokenizer(other.getVersion(), ".");
        StringTokenizer tokThis = new StringTokenizer(getVersion(), ".");

        // resultat
        boolean find = false;

        int result = 0;
        while (!find) {
            int otherPart = 0;
            int thisPart = 0;
            if (tokOther.hasMoreTokens()) {
                otherPart = Integer.parseInt(tokOther.nextToken());
            }
            if (tokThis.hasMoreTokens()) {
                thisPart = Integer.parseInt(tokThis.nextToken());
            }
            result = thisPart - otherPart;

            find = result != 0 || !(tokOther.hasMoreTokens() || tokThis.hasMoreElements());
        }

        return result;
    }

    @Override
    public String toString() {
        return "V" + value;
    }

    /**
     * @return value of the version
     */
    public String getVersion() {
        return value;
    }

    /**
     *
     * @param value the value to set
     */
    public void setVersion(String value) {
        this.value = value;
    }

    /**
     * Convertit les versions pour etre valides :
     *  - en java : "." interdit
     *  - en mysql, h2 ... : "." interdit
     *  @return la valeur ou les carateres interdits sont remplaces par '_'
     */
    public String getValidName() {
        String validName = value;

        // replace "."
        validName = validName.replaceAll("\\.", "_");

        return validName;
    }
}
