/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.migration.transformation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.migration.common.ProxyClass;
import org.nuiton.topia.migration.transformation.MigrationClass;
import org.nuiton.util.Version;

public class FinderMigration {
    private static String PACKAGE = "migration";
    private static Log logger = LogFactory.getLog(FinderMigration.class);

    public FinderMigration() {
    }

    public FinderMigration(String packag) {
        this();
        PACKAGE = packag;
    }

    public MigrationClass getMigrationClass(ProxyClass klass, Version base, Version next) {
        MigrationClass mcResult = null;
        String baseFullName = klass.getCanonicalName();
        String baseLittleName = baseFullName.substring(baseFullName.lastIndexOf(46) + 1);
        String basePackage = baseFullName.substring(0, baseFullName.lastIndexOf(46));
        String newClassName = basePackage + "." + PACKAGE + "." + "V" + base.getVersion() + "V" + next.getVersion() + "." + baseLittleName;
        try {
            Class.forName(newClassName);
            logger.debug((Object)("Using '" + newClassName + "' migration class"));
            mcResult = new MigrationClass(newClassName, baseFullName, base, next);
        }
        catch (ClassNotFoundException e) {
            logger.debug((Object)("No '" + newClassName + "' migration class"));
        }
        return mcResult;
    }
}

