/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.flyway;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.internal.util.Location;
import org.nuiton.topia.flyway.TopiaFlywayService;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaException;

public class TopiaFlywayServiceImpl
implements TopiaFlywayService {
    private static final Log log = LogFactory.getLog(TopiaFlywayServiceImpl.class);
    protected String flywayInitVersion = null;
    protected boolean useModelVersion = true;
    protected Flyway flyway;
    protected String modelVersion;

    public void initTopiaService(TopiaApplicationContext topiaApplicationContext, Map<String, String> serviceConfiguration) {
        this.modelVersion = topiaApplicationContext.getModelVersion();
        if (serviceConfiguration.containsKey("flyway.initVersion")) {
            this.flywayInitVersion = serviceConfiguration.get("flyway.initVersion");
            if (StringUtils.isBlank((CharSequence)this.flywayInitVersion)) {
                throw new IllegalArgumentException("'" + this.flywayInitVersion + "' must not be empty");
            }
        }
        if (serviceConfiguration.containsKey("useModelVersion")) {
            String useModelVersionString = serviceConfiguration.get("useModelVersion");
            if (StringUtils.isBlank((CharSequence)useModelVersionString)) {
                throw new IllegalArgumentException("'useModelVersion' must not be empty");
            }
            this.useModelVersion = Boolean.valueOf(useModelVersionString);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"init flyway service");
        }
        this.flyway = new Flyway();
        this.setDataSource(this.flyway, topiaApplicationContext);
        this.setLocations(this.flyway, topiaApplicationContext);
        this.doExtraConfiguration(this.flyway, topiaApplicationContext);
    }

    public Class<?>[] getPersistenceClasses() {
        return null;
    }

    protected void setDataSource(Flyway flyway, TopiaApplicationContext topiaApplicationContext) {
        ImmutableMap configuration = topiaApplicationContext.getConfiguration();
        String url = (String)configuration.get("hibernate.connection.url");
        String user = (String)configuration.get("hibernate.connection.username");
        String password = (String)configuration.get("hibernate.connection.password");
        flyway.setDataSource(url, user, password, new String[0]);
    }

    protected void setLocations(Flyway flyway, TopiaApplicationContext topiaApplicationContext) {
        String classpathMigrationPackage = topiaApplicationContext.getClass().getPackage().getName() + ".migration";
        ImmutableSet defaultLocations = ImmutableSet.of((Object)"db/migration", (Object)classpathMigrationPackage);
        LinkedHashSet<String> locations = new LinkedHashSet<String>();
        for (String defaultLocation : defaultLocations) {
            if (log.isInfoEnabled()) {
                log.info((Object)("will search for migration in location " + defaultLocation));
            }
            try {
                Location location = new Location(defaultLocation);
                Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(location.getPath());
                if (resources.hasMoreElements()) {
                    locations.add(defaultLocation);
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("migrations found in " + defaultLocation));
                    continue;
                }
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("no migration found in " + defaultLocation));
            }
            catch (IOException e) {
                throw new TopiaException((Throwable)e);
            }
        }
        String[] locationsArray = locations.toArray(new String[locations.size()]);
        flyway.setLocations(locationsArray);
    }

    protected void doExtraConfiguration(Flyway flyway, TopiaApplicationContext topiaApplicationContext) {
    }

    public void initOnCreateSchema() {
        String initVersion = this.modelVersion;
        if (log.isInfoEnabled()) {
            log.info((Object)("init flyway to version " + initVersion));
        }
        this.flyway.setInitVersion(initVersion);
        this.flyway.setInitDescription("schema creation called on application context by topia flyway service");
        this.flyway.init();
    }

    public void runSchemaMigration() {
        if (this.flywayInitVersion == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"schema exists, no flywayInitVersion found, let suppose flyway is already initialized");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("schema exists, will ask flyway to init if necessary to version " + this.flywayInitVersion));
            }
            this.flyway.setInitOnMigrate(true);
            this.flyway.setInitVersion(this.flywayInitVersion);
        }
        if (this.useModelVersion) {
            String targetVersion = this.modelVersion;
            if (log.isInfoEnabled()) {
                log.info((Object)("schema exists, will run flyway migration up to target version " + targetVersion));
            }
            this.flyway.setTarget(targetVersion);
        } else if (log.isInfoEnabled()) {
            log.info((Object)"schema exists, no target version specified, will run flyway migration for all existing versions");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"run flyway migration");
        }
        this.flyway.migrate();
        this.flyway = null;
    }
}

