/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.internal;

import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaIdFactory;

public class DefaultTopiaIdFactory
implements TopiaIdFactory {
    @Override
    public <E extends TopiaEntity> String newTopiaId(Class<E> entityClass, TopiaEntity topiaEntity) {
        if (!entityClass.isInterface()) {
            throw new IllegalArgumentException("Only interface is permit to create id: " + entityClass);
        }
        String result = entityClass.getName() + this.getSeparator() + UUID.randomUUID().toString();
        return result;
    }

    @Override
    public <E extends TopiaEntity> Class<E> getClassName(String topiaId) {
        String className = StringUtils.substringBefore((String)topiaId, (String)this.getSeparator());
        try {
            Class<?> entityClass = Class.forName(className);
            return entityClass;
        }
        catch (ClassNotFoundException e) {
            throw new TopiaException("can't find class for topiaId = '" + topiaId + "'", e);
        }
    }

    @Override
    public String getSeparator() {
        return "_";
    }

    @Override
    public String getRandomPart(String topiaId) {
        return StringUtils.substringAfter((String)topiaId, (String)this.getSeparator());
    }
}

