package org.nuiton.topia.persistence.internal;

/*
 * #%L
 * ToPIA :: Persistence
 * $Id: LegacyTopiaIdFactory.java 2981 2014-01-17 17:38:55Z athimel $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-9/topia-persistence/src/main/java/org/nuiton/topia/persistence/internal/LegacyTopiaIdFactory.java $
 * %%
 * Copyright (C) 2004 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaIdFactory;
import org.nuiton.topia.persistence.TopiaNotFoundException;

/**
 * Implements {@link TopiaIdFactory} with Topia 2.x and before ids.
 * Suitable if you already have a database and your application need
 * to generate ids like the old ones.
 *
 * @since 3.0
 */
public class LegacyTopiaIdFactory implements TopiaIdFactory {

    @Override
    public <E extends TopiaEntity> String newTopiaId(Class<E> entityClass, TopiaEntity topiaEntity) {
        if (!entityClass.isInterface()) {
            throw new IllegalArgumentException(
                    "Only interface is permit to create id: " + entityClass);
        }
        double random = Math.random();
        while (Double.toString(random).contains("E-")) {
            random = Math.random();
        }
        return entityClass.getName() + getSeparator() + System.currentTimeMillis() + '#' + random;
    }

    /**
     * Extrait la classe du topiaId.
     *
     * @param topiaId
     * @return class
     * @throws TopiaNotFoundException
     */
    @Override
    public <E extends TopiaEntity> Class<E> getClassName(String topiaId) {
        String className = StringUtils.substringBefore(topiaId, getSeparator());
//        int i = topiaId.indexOf('#');
//        if (i > 0) {
//            className = topiaId.substring(0, i);
//        }
        try {
            Class result = Class.forName(className);
            return result;
        } catch (ClassNotFoundException eee) {
            throw new TopiaNotFoundException("Can't find class for " + topiaId,
                                             eee);
        }
    }

    @Override
    public String getSeparator() {
        return "#";
    }

    @Override
    public String getRandomPart(String topiaId) {
        return StringUtils.substringBefore(topiaId, getSeparator());
    }
}
