/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import org.nuiton.topia.persistence.TopiaEntity;

public class TopiaEntities {
    protected static final Function<TopiaEntity, String> GET_TOPIA_ID = new Function<TopiaEntity, String>(){

        public String apply(TopiaEntity input) {
            return input == null ? null : input.getTopiaId();
        }
    };

    protected static Predicate<TopiaEntity> entityHasId(String id) {
        return Predicates.compose((Predicate)Predicates.equalTo((Object)id), GET_TOPIA_ID);
    }

    public static <E extends TopiaEntity> E findByTopiaId(Iterable<E> entities, String id) {
        TopiaEntity result;
        if (entities == null) {
            result = null;
        } else {
            Optional eOptional = Iterables.tryFind(entities, TopiaEntities.entityHasId(id));
            result = (TopiaEntity)eOptional.orNull();
        }
        return (E)result;
    }

    public static Function<TopiaEntity, String> getTopiaIdFunction() {
        return GET_TOPIA_ID;
    }
}

