/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.nuiton.topia.TopiaDatabase;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestTopiaPersistenceContext;
import org.nuiton.topia.persistence.DepthEntityVisitor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.ExportXMLVisitor;
import org.nuiton.topiatest.Address;
import org.nuiton.topiatest.AddressTopiaDao;
import org.nuiton.topiatest.Company;
import org.nuiton.topiatest.CompanyTopiaDao;
import org.nuiton.topiatest.Department;
import org.nuiton.topiatest.DepartmentTopiaDao;
import org.nuiton.topiatest.Employe;
import org.nuiton.topiatest.EmployeTopiaDao;

public class EntityVisitorExportXmlTest {
    private static final Log log = LogFactory.getLog(EntityVisitorExportXmlTest.class);
    @Rule
    public final TopiaDatabase db = new TopiaDatabase();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() throws TopiaException {
        TopiaTestTopiaPersistenceContext newContext = this.db.beginTransaction();
        try {
            CompanyTopiaDao companyDAO = newContext.getCompanyDao();
            Company clCompany = (Company)companyDAO.create("name", "CodeLutin", new Object[0]);
            EmployeTopiaDao employeDAO = newContext.getEmployeDao();
            Employe empl1 = (Employe)employeDAO.create("name", "boss", new Object[]{"salary", 30000});
            AddressTopiaDao adressDAO = newContext.getAddressDao();
            Address addr1 = (Address)adressDAO.create("city", "Nantes", new Object[]{"adress", "12 Avenue Jules Vernes"});
            empl1.setAddress(addr1);
            Employe empl2 = (Employe)employeDAO.create("name", "boss2", new Object[]{"salary", 29000});
            Address addr2 = (Address)adressDAO.create("city", "Nantes", new Object[]{"adress", "12 Avenue Jules Vernes"});
            empl2.setAddress(addr2);
            DepartmentTopiaDao departmentDAO = newContext.getDepartmentDao();
            Department depComm = (Department)departmentDAO.create("name", "Commercial", new Object[0]);
            depComm.setLeader(empl1);
            Department depDev = (Department)departmentDAO.create("name", "Dev", new Object[0]);
            depDev.setLeader(empl2);
            clCompany.addDepartment(depComm);
            clCompany.addDepartment(depDev);
            newContext.commitTransaction();
        }
        finally {
            newContext.closeContext();
        }
    }

    @Test
    public void testExportXMLDepth() throws TopiaException {
        TopiaTestTopiaPersistenceContext context = this.db.beginTransaction();
        CompanyTopiaDao companyDAO = context.getCompanyDao();
        Object clCompany = companyDAO.findByName("CodeLutin");
        ExportXMLVisitor delegateVisitor = new ExportXMLVisitor();
        DepthEntityVisitor visitor = new DepthEntityVisitor((EntityVisitor)delegateVisitor);
        clCompany.accept((EntityVisitor)visitor);
        if (log.isInfoEnabled()) {
            log.info((Object)("Export XML = \n" + ((Object)delegateVisitor).toString()));
        }
    }
}

