/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.util;

import java.util.Collection;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.EntityOperator;
import org.nuiton.topiatest.Company;
import org.nuiton.topiatest.CompanyImpl;
import org.nuiton.topiatest.Department;
import org.nuiton.topiatest.DepartmentImpl;
import org.nuiton.topiatest.Employe;
import org.nuiton.topiatest.EmployeImpl;
import org.nuiton.topiatest.Personne;
import org.nuiton.topiatest.PersonneImpl;

public class EntityOperatorTest {
    static EntityOperator<Company> operationC;
    static EntityOperator<Employe> operationE;
    static EntityOperator<Personne> operationP;
    static EntityOperator<Department> operationD;
    Company c;
    Department d;
    Employe e;
    Personne p;

    @BeforeClass
    public static void setUpClass() throws Exception {
        operationC = TopiaTestDAOHelper.getOperator(Company.class);
        operationE = TopiaTestDAOHelper.getOperator(Employe.class);
        operationP = TopiaTestDAOHelper.getOperator(Personne.class);
        operationD = TopiaTestDAOHelper.getOperator(Department.class);
    }

    @AfterClass
    public static void tearDownClass() throws Throwable {
        operationC.finalize();
        operationE.finalize();
        operationP.finalize();
        operationD.finalize();
    }

    @Before
    public void setUp() {
        this.c = new CompanyImpl();
        this.d = new DepartmentImpl();
        this.e = new EmployeImpl();
        this.p = new PersonneImpl();
    }

    @After
    public void tearDown() {
        this.c = null;
        this.d = null;
        this.e = null;
        this.p = null;
    }

    @Test
    public void testGet() {
        String name = "name";
        this.e.setName("name");
        Object actual = operationE.get("name", (TopiaEntity)this.e);
        Assert.assertEquals((Object)name, (Object)actual);
        actual = operationP.get("name", (TopiaEntity)this.e);
        Assert.assertEquals((Object)name, (Object)actual);
        actual = operationD.get("company", (TopiaEntity)this.d);
        Assert.assertNull((Object)actual);
        this.d.setCompany(this.c);
        actual = operationD.get("company", (TopiaEntity)this.d);
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)this.c, (Object)actual);
        actual = operationC.get("department", (TopiaEntity)this.c);
        Assert.assertNull((Object)actual);
        this.c.addDepartment(this.d);
        actual = operationC.get("department", (TopiaEntity)this.c);
        Assert.assertNotNull((Object)actual);
        Assert.assertFalse((boolean)((Collection)actual).isEmpty());
    }

    @Test
    public void testSet() {
        String name = "name";
        operationE.set("name", (TopiaEntity)this.e, (Object)"name");
        Assert.assertEquals((Object)name, (Object)this.e.getName());
        name = "name2";
        operationP.set("name", (TopiaEntity)this.e, (Object)"name2");
        Assert.assertEquals((Object)name, (Object)this.e.getName());
    }

    @Test
    public void testGetChild() {
        String topiaId = "0";
        Object actual = operationC.get("department", (TopiaEntity)this.c);
        Assert.assertNull((Object)actual);
        actual = operationC.getChild("department", (TopiaEntity)this.c, topiaId);
        Assert.assertNull((Object)actual);
        this.c.addDepartment(this.d);
        actual = operationC.get("department", (TopiaEntity)this.c);
        Assert.assertNotNull((Object)actual);
        Assert.assertFalse((boolean)((Collection)actual).isEmpty());
        actual = operationC.getChild("department", (TopiaEntity)this.c, topiaId);
        Assert.assertNull((Object)actual);
        this.d.setTopiaId(topiaId);
        actual = operationC.getChild("department", (TopiaEntity)this.c, topiaId);
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)this.d, (Object)actual);
    }

    @Test
    public void testAddChild() {
        Assert.assertTrue((boolean)this.c.isDepartmentEmpty());
        operationC.addChild("department", (TopiaEntity)this.c, (Object)this.d);
        Assert.assertFalse((boolean)this.c.isDepartmentEmpty());
        Assert.assertEquals((Object)this.d, (Object)this.c.getDepartment().iterator().next());
    }

    @Test
    public void testIsChildEmpty() {
        Assert.assertTrue((boolean)this.c.isDepartmentEmpty());
        boolean actual = operationC.isChildEmpty("department", (TopiaEntity)this.c);
        Assert.assertTrue((boolean)actual);
        this.c.addDepartment(this.d);
        actual = operationC.isChildEmpty("department", (TopiaEntity)this.c);
        Assert.assertFalse((boolean)actual);
    }

    @Test
    public void testChildSize() {
        Assert.assertTrue((boolean)this.c.isDepartmentEmpty());
        int actual = operationC.sizeChild("department", (TopiaEntity)this.c);
        Assert.assertEquals((long)0L, (long)actual);
        this.c.addDepartment(this.d);
        actual = operationC.sizeChild("department", (TopiaEntity)this.c);
        Assert.assertEquals((long)1L, (long)actual);
        this.c.clearDepartment();
        actual = operationC.sizeChild("department", (TopiaEntity)this.c);
        Assert.assertEquals((long)0L, (long)actual);
    }

    @Test
    public void testRemoveChild() {
        Assert.assertTrue((boolean)this.c.isDepartmentEmpty());
        this.c.addDepartment(this.d);
        Assert.assertFalse((boolean)this.c.isDepartmentEmpty());
        operationC.removeChild("department", (TopiaEntity)this.c, (Object)this.d);
        Assert.assertTrue((boolean)this.c.isDepartmentEmpty());
    }
}

