/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: EnumTest.java 2305 2011-06-21 15:46:57Z bleny $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.6.3/topia-persistence/src/test/java/org/nuiton/topiatest/EnumTest.java $
 * %%
 * Copyright (C) 2004 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.topiatest;

import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.topia.TestHelper;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.TopiaTestDAOHelper;

import java.io.File;
import java.io.IOException;

/**
 * Test the support of possibility to have an attribute of type enumeration
 * in a entity
 */
public class EnumTest {

    private static final Log log = LogFactory.getLog(EnumTest.class);

    protected static File testBasedir;

    @BeforeClass
    public static void setUpClass() throws Exception {
        testBasedir = TestHelper.getTestBasedir(EnumTest.class);
    }

    protected TopiaContext initTopiaContext(String testName) throws IOException, TopiaNotFoundException {
        TopiaContext root = TestHelper.initTopiaContext(testBasedir,
                                                        "/TopiaContextImpl.properties",
                                                        testName);
        return root;
    }

    /**
     * Create an entity having two field of type enumeration. One is stored
     * using ordinal, the other using the name.
     *
     * The test check that values are stored, and that find methods works
     *
     * @throws Exception
     */
    @Test
    public void storeEntityWithEnumValue() throws Exception {
        TopiaContext root = initTopiaContext("storeEntityWithEnumValue");
        TopiaContext transaction = root.beginTransaction();

        PersonneDAO dao = TopiaTestDAOHelper.getPersonneDAO(transaction);
        Personne personne = new PersonneImpl();
        personne.setGender(Gender.FEMALE);
        personne.setOtherGender(Gender.MALE);
        dao.create(personne);
        String topiaId = personne.getTopiaId();
        transaction.commitTransaction();
        transaction.closeContext();

        transaction = root.beginTransaction();
        dao = TopiaTestDAOHelper.getPersonneDAO(transaction);
        dao.findByTopiaId(topiaId);
        Assert.assertEquals(Gender.FEMALE, personne.getGender());
        Assert.assertEquals(Gender.MALE, personne.getOtherGender());

        Assert.assertNotNull(dao.findByGender(Gender.FEMALE));
        Assert.assertNotNull(dao.findByOtherGender(Gender.MALE));
        transaction.closeContext();
    }
}
